#ifndef OCRLANGUAGESETTINGS_H
#define OCRLANGUAGESETTINGS_H

#include <QMainWindow>
#include <QString>
#include <QMap>

class QNetworkReply;
class DownloadFileManager;
class QListWidgetItem;
class QMessageBox;

namespace Ui {
    class OCRLanguageSettings;
}

class OCRLanguageSettings : public QMainWindow {
    Q_OBJECT
public:
    explicit OCRLanguageSettings(QWidget *parent = 0);
    ~OCRLanguageSettings();

protected:
    void changeEvent(QEvent *e);
    virtual void
    hideEvent ( QHideEvent * event );

private slots:

    void
    updateProgressBar(qint64, qint64);

    void
    cancelDownload();

    void
    showError( const QString &stringError );

    void
    downloadLanguage( QListWidgetItem* );

    void
    downloadWasFinishedSlot();

    void
    fileWasSavedSlot()
    {
        populateInstalledLanguages();
    }



private:
    /*
     *  Populates the listwidget with the installed languages.
     */
    void
    populateInstalledLanguages();

    void
    populateAvailableLanguages();

    void
    createMyHashmap();

private:
    Ui::OCRLanguageSettings *ui;
    DownloadFileManager *mDownloadFileManager;

    QMap<QString, QString> mMyHash;
    QMessageBox *mMessageBox;
};

#endif // OCRLANGUAGESETTINGS_H
