#include "ctworkingthread.h"
#include "customtablewidget.h"
#include <QDebug>
#include <QStringList>
#include <QImageReader>

CTWorkingThread::CTWorkingThread( QObject *parent):
    QThread(parent)    
{

    tableWidget = dynamic_cast< CustomTableWidget *>(parent);

    QImage brokeImage,dirImage, dirImpImage;

    brokeImage = QImage( ":/CustomDialog/brokeImage.png" );
    dirImage = QImage( ":/CustomDialog/dirPicture.png" );
    dirImpImage = QImage( ":/CustomDialog/dirPictureImp.png" );

    savedImages.insert( "dirImage", dirImage );

    savedImages.insert( "brokeImage", brokeImage ) ;

    savedImages.insert( "//home", dirImpImage ) ;
    savedImages.insert( "/home/user", dirImpImage ) ;
    savedImages.insert( "/home/user/MyDocs", dirImpImage ) ;
    savedImages.insert( "/home/user/MyDocs/.images", dirImpImage ) ;
    savedImages.insert( "/home/user/MyDocs/DCIM", dirImpImage ) ;
    savedImages.insert( "//media", dirImpImage ) ;
    savedImages.insert( "/media/mmc1", dirImpImage ) ;
    savedImages.insert( "/media/mmc1/DCIM", dirImpImage ) ;
}

void
CTWorkingThread::run()
{

    if( tableWidget && fileList.size() != 0 )
    {
    int columnCount = tableWidget->columnCount();

        for( int i = 0; i < fileList.size(); i++ )
        {

             emit  imageProcessed(  i / columnCount ,
                                    i % columnCount,
                                    returnThumbnailPicture( path +
                                                      QDir::separator() +
                                                      fileList.at(i) ) );
        }
    }
}

void
CTWorkingThread::prepairToStart(const QString &path,
                                const QStringList &fileList)
{
   this->path = path;
   this->fileList = fileList;
}


QImage
CTWorkingThread::returnThumbnailPicture(const QString &path )
{

    QImageReader image_reader( path );
    image_reader.setQuality( 0 );
    image_reader.setScaledSize( QSize( 110, 110 ) );

    QImage image = image_reader.read();

    if( !image.isNull() )
    {
        return image;
    }
    else
    {
        QDir pathDir = QDir( path );
        if ( pathDir.exists() )
        {
            if( this->savedImages.contains( path ) )
                return this->savedImages.value( path );
            else
                return this->savedImages.value( "dirImage" );

        }
        else
        {

            return this->savedImages.value("brokeImage");
        }
    }




}
