#ifndef DOWNLOADFILEMANAGER_H
#define DOWNLOADFILEMANAGER_H

#include <QObject>
#include <QNetworkReply>
#include <QString>

class QNetworkAccessManager;
class QMessageBox;



class DownloadFileManager : public QObject
{
Q_OBJECT
public:
    explicit DownloadFileManager( QObject *parent = 0 );
    ~DownloadFileManager();

    void
    downloadFile( const QString &fieName );

signals:
    /*
     *  Signal emited to allow the GUI progress bar to be uploaded
     */
    void
    updateProgressBar(qint64, qint64);

    /*
     *  Signal emitted to allow the GUI to show the error.
     */
    void errorProcessed( const QString &error );

    void downloadWasFinished();

    void
    fileWasSaved();

public slots:
    /*
     *  Cancel the current download.
     */
    void
    abortCurrentDownload();

private slots:
    /*
     *    Slot is called when the download is finished.
     *    The file is ready for read now from the networkReply pointer received
     *  as param.
     */
    void
    downloadFinished(QNetworkReply *networkReply );

    /*
     *  Process the error code
     */
    void
    processError( QNetworkReply::NetworkError );

private:

QNetworkAccessManager *mNetworkManager;
QNetworkReply *mNetworkReply;

static const QString baseServerAddress;
QString file;

QMessageBox *mMessageBox;

};

#endif // DOWNLOADFILEMANAGER_H
