//-----------------------------------------------------------------------------
#include "ImageScrollView.h"
//-----------------------------------------------------------------------------

#include <QMouseEvent>
#include <QScrollBar>
/*
#ifdef Q_WS_MAEMO_5
  #include <QtMaemo5/QMaemo5KineticScroller>
#endif
*/
#include <QDebug>

//-----------------------------------------------------------------------------
ImageScrollView::ImageScrollView(QWidget* a_parent):
  QScrollArea(a_parent)
{
  setContextMenuPolicy(Qt::NoContextMenu);

  m_moveEnabled = true;
  m_mouseDown = false;

  m_horizontalMin = 0;
  m_horizontalMax = 0;
  m_horizontalValue = 0;

  m_verticalMin = 0;
  m_verticalMax = 0;
  m_verticalValue = 0;

  setAlignment(Qt::AlignCenter);
  setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
  setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);

  connect(horizontalScrollBar(), SIGNAL(rangeChanged(int,int)), this, SLOT(horizontalRangeChanged(int,int)));
  connect(horizontalScrollBar(), SIGNAL(valueChanged(int)), this, SLOT(horizontalValueChanged(int)));
  connect(verticalScrollBar(), SIGNAL(rangeChanged(int,int)), this, SLOT(verticalRangeChanged(int,int)));
  connect(verticalScrollBar(), SIGNAL(valueChanged(int)), this, SLOT(verticalValueChanged(int)));
/*
  #ifdef Q_WS_MAEMO_5
    new QMaemo5KineticScroller(this);
  #else
    this->setProperty("FingerScrollable", true);
  #endif
*/
}

//-----------------------------------------------------------------------------
ImageScrollView::~ImageScrollView()
{
}

//-----------------------------------------------------------------------------
QSize ImageScrollView::countMaximumViewportSize() const
{
/*  QSize maxSize(viewport()->size());
  QSize sizeScrollBars( verticalScrollBar() && verticalScrollBar()->isVisible() ? verticalScrollBar()->width() : 0,
                        horizontalScrollBar() && horizontalScrollBar()->isVisible() ? horizontalScrollBar()->height() : 0 );
*/
  return (viewport()->size());
}

//-----------------------------------------------------------------------------
void ImageScrollView::translateView(const QPoint& a_pt)
{
  if(horizontalScrollBar() && a_pt.x())
    horizontalScrollBar()->setValue(horizontalScrollBar()->value() + a_pt.x());

  if(verticalScrollBar() && a_pt.y())
    verticalScrollBar()->setValue(verticalScrollBar()->value() + a_pt.y());

  emit viewportScrolled();
}

//-----------------------------------------------------------------------------
void ImageScrollView::mousePressEvent(QMouseEvent* a_event)
{
  if(m_moveEnabled)
  {
    m_mouseDown = true;
    m_lastPos = a_event->pos();

    a_event->accept();
  }
  else
    QScrollArea::mousePressEvent(a_event);
}

//-----------------------------------------------------------------------------
void ImageScrollView::mouseMoveEvent(QMouseEvent* a_event)
{
  if(m_mouseDown)
  {
    QPoint ptTranslation = m_lastPos - a_event->pos();
    m_lastPos = a_event->pos();
    translateView(ptTranslation);

    a_event->accept();
  }
  else
    QScrollArea::mouseMoveEvent(a_event);
}

//-----------------------------------------------------------------------------
void ImageScrollView::mouseReleaseEvent(QMouseEvent* a_event)
{
  if(m_mouseDown)
  {
    m_mouseDown = false;

    QPoint ptTranslation = m_lastPos - a_event->pos();

    m_lastPos = a_event->pos();
    translateView(ptTranslation);

    a_event->accept();
  }
  else
    QScrollArea::mouseReleaseEvent(a_event);
}

//-----------------------------------------------------------------------------
void ImageScrollView::horizontalRangeChanged(int a_min, int a_max)
{
  int oldSize = m_horizontalMax - m_horizontalMin;
  qreal position = 0.5;
  if(oldSize > 0)
    position = qreal(m_horizontalValue - m_horizontalMin) / qreal(oldSize);

  m_horizontalMax = a_max;
  m_horizontalMin = a_min;

  int newSize = m_horizontalMax - m_horizontalMin;
  int newValue = int(qreal(newSize) * position) + m_horizontalMin;

  if(horizontalScrollBar())
    horizontalScrollBar()->setValue(newValue);
}

//-----------------------------------------------------------------------------
void ImageScrollView::horizontalValueChanged(int a_value)
{
  m_horizontalValue = a_value;
}

//-----------------------------------------------------------------------------
void ImageScrollView::verticalRangeChanged(int a_min, int a_max)
{
  int oldSize = m_verticalMax - m_verticalMin;
  qreal position = 0.5;
  if(oldSize > 0)
    position = qreal(m_verticalValue - m_verticalMin) / qreal(oldSize);

  m_verticalMax = a_max;
  m_verticalMin = a_min;

  int newSize = m_verticalMax - m_verticalMin;
  int newValue = int(qreal(newSize) * position) + m_verticalMin;

  if(verticalScrollBar())
    verticalScrollBar()->setValue(newValue);
}

//-----------------------------------------------------------------------------
void ImageScrollView::verticalValueChanged(int a_value)
{
  m_verticalValue = a_value;
}

//-----------------------------------------------------------------------------
