#ifndef CONTEXT_H
#define CONTEXT_H
//-----------------------------------------------------------------------------

#include <QObject>

#include <QDir>

//-----------------------------------------------------------------------------
class Application;
class Settings;

class OCR;
class Translator;

//-----------------------------------------------------------------------------
class Context:
    public QObject
{
  Q_OBJECT

  public:
    Context(Application* a_application);
    ~Context();

  public:
    Application* application();
    Settings* settings();

    OCR* ocr();
    Translator* translator();

    const QDir& workingFolder() const;
    const QString& programInstallDir() const;

  protected:
    Application* m_application;
    Settings* m_settings;

    OCR* m_ocr;
    Translator* m_translator;

    QDir m_dirWorkingFolder;
    QString m_strProgramInstallDir;
};

//-----------------------------------------------------------------------------
#endif // CONTEXT_H
