#ifndef IMAGEWIDGET_H
#define IMAGEWIDGET_H
//-----------------------------------------------------------------------------

#include <QWidget>

#include <QPixmap>

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
class ImageWidget:
  public QWidget
{
  Q_OBJECT

  public:
    ImageWidget(QWidget* a_parent);
    ~ImageWidget();

  signals:
    void toggleBusy(bool a_busy);

  public slots:
    void setMaximumViewportSize(const QSize& a_size);

    void loadFile(const QString& a_path);

    void zoomIn();
    void zoomOut();
    void zoomTo(qreal a_zoom);

    void rotate();
    void resetCrop();

    void saveTo(const QString& a_path, const QString& a_type);

    void visibleRectChanged();

  protected:
    virtual void mousePressEvent(QMouseEvent* a_event);
    virtual void mouseReleaseEvent(QMouseEvent* a_event);
    virtual void mouseMoveEvent(QMouseEvent* a_event);

    virtual void resizeEvent(QResizeEvent* a_event);
    virtual void paintEvent(QPaintEvent* a_event);

    void resetState();

    void updateDrawingImage();

    QRect countVisibleRect() const;
    QSize imageBaseSize() const;
    QPolygon cropPolygon(const QSize& a_size) const;
    void translateCrop(const QPointF& a_translation);
    void resizeCrop(const QPoint& a_translation);

  private:
    bool m_hasImage;
    QSize m_maxSize;
    qreal m_zoomFactor;

    QPixmap m_imageOriginal;
    QPoint m_pointDrawing;
    QPixmap m_imageDrawing;
    qreal m_cropRotation;
    QRectF m_rectCrop;

    enum EMouseState
    {
      MouseState_None,
      MouseState_Move,
      MouseState_Resize,
    };
    EMouseState m_mouseState;
    QPoint m_pointLastMousePos;
};

//-----------------------------------------------------------------------------
#endif // IMAGEWIDGET_H
