#ifndef IMAGESCROLLVIEW_H
#define IMAGESCROLLVIEW_H
//-----------------------------------------------------------------------------

#include <QScrollArea>

//-----------------------------------------------------------------------------
class ImageScrollView:
  public QScrollArea
{
  Q_OBJECT

  public:
    ImageScrollView(QWidget* a_parent);
    ~ImageScrollView();

  signals:
    void viewportScrolled();

  public:
    QSize countMaximumViewportSize() const;

  public slots:
    void translateView(const QPoint& a_pt);

  protected:
    virtual void mousePressEvent(QMouseEvent* a_event);
    virtual void mouseReleaseEvent(QMouseEvent* a_event);
    virtual void mouseMoveEvent(QMouseEvent* a_event);

  protected slots:
    void horizontalRangeChanged(int a_min, int a_max);
    void horizontalValueChanged(int a_value);
    void verticalRangeChanged(int a_min, int a_max);
    void verticalValueChanged(int a_value);

  protected:
    bool m_moveEnabled;
    bool m_mouseDown;
    QPoint m_lastPos;

    int m_horizontalMin;
    int m_horizontalMax;
    int m_horizontalValue;

    int m_verticalMin;
    int m_verticalMax;
    int m_verticalValue;
};

//-----------------------------------------------------------------------------
#endif // IMAGESCROLLVIEW_H
