//-----------------------------------------------------------------------------
#include "View_Image.h"
#include "ui_View_Image.h"
//-----------------------------------------------------------------------------

#include "Context.h"
#include "Definitions.h"
#include "common/Language.h"
#include "ImageScrollView.h"
#include "ImageWidget.h"
#include "View_Translate.h"
#include "settings/Settings.h"
#include "settings/SettingsDialog.h"

#include <QKeyEvent>
#include <QX11Info>

#ifdef Q_WS_MAEMO_5
  #include <QtMaemo5/QMaemo5ValueButton>
#endif

#include <QDebug>

#include <X11/Xlib.h>
#include <X11/Xatom.h>

//-----------------------------------------------------------------------------
View_Image::View_Image(Context* a_context, QWidget* a_parent):
  View(a_context, a_parent),
  m_ui(new Ui::View_Image)
{
  qDebug() << "View_Image::View_Image()";

  m_ui->setupUi(this);

  m_widgetScroll = new ImageScrollView(this);
  m_widgetImage = new ImageWidget(this);
  m_widgetScroll->setWidget(m_widgetImage);
  m_ui->layout->insertWidget(0, m_widgetScroll);

  QString strSourceLabel(tr("Language"));
  m_buttonSourceLang = NULL;
  #ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton* buttonSourceLang = new QMaemo5ValueButton(strSourceLabel, this);
    buttonSourceLang->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    m_buttonSourceLang = buttonSourceLang;
  #else
    m_buttonSourceLang = new QPushButton(strSourceLabel, this);
  #endif
  refreshLanguageButtons();
  m_ui->layoutCenterButtons->insertWidget(0, m_buttonSourceLang);

  connect(m_context->settings(), SIGNAL(settingsChanged(quint32)), this, SLOT(onSettingsChanged(quint32)));

  connect(m_ui->translate, SIGNAL(clicked()), this, SLOT(onTranslate()));
  connect(m_buttonSourceLang, SIGNAL(clicked()), this, SLOT(onSourceLang()));

  connect(m_ui->zoomIn, SIGNAL(clicked()), m_widgetImage, SLOT(zoomIn()));
  connect(m_ui->zoomOut, SIGNAL(clicked()), m_widgetImage, SLOT(zoomOut()));
  connect(m_ui->rotate, SIGNAL(clicked()), m_widgetImage, SLOT(rotate()));
  connect(m_ui->reset, SIGNAL(clicked()), m_widgetImage, SLOT(resetCrop()));

  connect(m_widgetImage, SIGNAL(toggleBusy(bool)), this, SLOT(toggleBusy(bool)));

  connect(m_widgetScroll, SIGNAL(viewportScrolled()), m_widgetImage, SLOT(visibleRectChanged()));

  // Listen to zoom key
  unsigned long value = 1;
  Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", 0);
  XChangeProperty(QX11Info::display(), winId(), atom, XA_INTEGER, 32, PropModeReplace, (unsigned char*) &value, 1);
}

//-----------------------------------------------------------------------------
View_Image::~View_Image()
{
  qDebug() << "View_Image::~View_Image()";

  delete m_ui;
}

//-----------------------------------------------------------------------------
void View_Image::initialize(const QString& a_pathPicture)
{
  m_widgetImage->setMaximumViewportSize(m_widgetScroll->countMaximumViewportSize());
  m_widgetImage->loadFile(a_pathPicture);
}

//-----------------------------------------------------------------------------
void View_Image::onTranslate()
{
  // Save image
  m_widgetImage->saveTo(IMAGE_FILE_NAME, IMAGE_FILE_TYPE);

  // Show translate view
  View_Translate* viewTranslate = new View_Translate(m_context, this);
  viewTranslate->initialize(true);
  viewTranslate->show();
}

//-----------------------------------------------------------------------------
void View_Image::onSourceLang()
{
  SettingsDialog::changeSourceLanguage(this, m_context->settings());
}

//-----------------------------------------------------------------------------
void View_Image::onSettingsChanged(quint32 a_changed)
{
  refreshLanguageButtons();
}

//-----------------------------------------------------------------------------
void View_Image::keyReleaseEvent(QKeyEvent* a_event)
{
  if(a_event->matches(QKeySequence::ZoomIn) || a_event->key() == Qt::Key_F7)
  {
    m_widgetImage->zoomIn();
    a_event->accept();
    return;
  }
  else if(a_event->matches(QKeySequence::ZoomOut) || a_event->key() == Qt::Key_F8)
  {
    m_widgetImage->zoomOut();
    a_event->accept();
    return;
  }

  QWidget::keyReleaseEvent(a_event);
}

//-----------------------------------------------------------------------------
void View_Image::refreshLanguageButtons()
{
  #ifdef Q_WS_MAEMO_5
    if(QMaemo5ValueButton* button = qobject_cast<QMaemo5ValueButton*>(m_buttonSourceLang))
      button->setValueText(Language::toString(m_context->settings()->langSource()));
  #else
    QString strSourceLabel(tr("Language"));
    m_buttonSourceLang->setText(strSourceLabel + QString(": ") + Language::toString(m_context->settings()->langSource()));
  #endif
}

//-----------------------------------------------------------------------------
