#ifndef SETTINGS_H
#define SETTINGS_H
//-----------------------------------------------------------------------------

#include <QObject>

//-----------------------------------------------------------------------------
class Settings:
    public QObject
{
  Q_OBJECT

  public:
    enum EChangeFlag
    {
      ChangeFlag_None = 0,

      ChangeFlag_OpenDir    = 0x00000001,
      ChangeFlag_LangSource = 0x00000002,
      ChangeFlag_LangTarget = 0x00000004,
    };


  public:
    Settings(QObject* a_parent = 0);
    ~Settings();

  public:
    void load();
    void save();

  signals:
    void settingsChanged(quint32 a_changed);

  public:
    int langSource() const;
    void setLangSource(int a);

    int langTarget() const;
    void setLangTarget(int a);

    const QList<int>& supportedLangSource() const;
    void setSupportedLangSource(const QList<int>& a);

    const QList<int>& supportedLangTarget() const;
    void setSupportedLangTarget(const QList<int>& a);

    const QString& openDir() const;
    void setOpenDir(const QString& a);

  protected:
    quint32 m_changed;

    int m_langSource;
    int m_langTarget;

    QList<int> m_supportedSourceLang;
    QList<int> m_supportedTargetLang;

    QString m_openDir;
};

//-----------------------------------------------------------------------------
#endif // SETTINGS_H
