#include "tableitem.h"
#include "ui_tableitem.h"

#include <QtGui>

TableItem::TableItem(const QPixmap &picture,
                     const QString &fileName,
                     QWidget *parent) :
    QWidget(parent),    
    ui(new Ui::TableItem)
{
    ui->setupUi(this);

    ui->pictureLabel->setPixmap( picture );

    QFont font = this->font();
    QFontMetrics fontMetrix = QFontMetrics( font );

    this->fullName = fileName;
    ui->fileName->setText(  fontMetrix.elidedText( fileName, Qt::ElideRight, ui->fileName->width() ) );
}

TableItem::~TableItem()
{    
    delete ui;
}

void TableItem::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QLabel *
TableItem::getPictureLabel()
{
    return ui->pictureLabel;
}

