#include "CameraWidget.h"
#include "ui_CameraWidget.h"

#include "Context.h"
#include "Definitions.h"
#include "View.h"
#include "View_Image.h"

#include <QDebug>
#include <QWidget>
#include <QMessageBox>
#include <QProcess>

#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
#include <gst/interfaces/photography.h>
#include <gst/interfaces/photography-enumtypes.h>
#include "glib.h"

#include <QTimer>

CameraWidget::CameraWidget(Context* a_context, QWidget* a_parent):
  View(a_context, a_parent),
  m_ui(new Ui::CameraWidget)
{
  qDebug() << "CameraWidget::CameraWidget()";
  m_ui->setupUi(this);
  QTimer::singleShot( 100, this, SLOT( initialize() ) );

}

CameraWidget::~CameraWidget()
{
	m_ui->widget->hide();
	gst_element_set_state (pipeline, GST_STATE_NULL);
	gst_object_unref (pipeline);
}

void CameraWidget::initialize()
{
    QObjectList list = this->children();
    nr_children = list.count();

    qDebug() << "CameraWidget::initialize()" ;

    WId xwinid = m_ui->widget->winId();

    src = gst_element_factory_make ("v4l2src", NULL);//, videotestsrc

    vscale = gst_element_factory_make ("videoscale", NULL);//, videotestsrc

    sink= gst_element_factory_make ("xvimagesink", NULL);

    pipeline = gst_pipeline_new ("xvoverlay");

    gst_bin_add_many (GST_BIN (pipeline), src, vscale, sink, NULL);

    gst_element_link_many (src,vscale, sink, NULL);

    QApplication::syncX();

    gst_x_overlay_set_xwindow_id (GST_X_OVERLAY (sink), (gulong)(xwinid));

    gst_element_set_state (pipeline, GST_STATE_NULL);

    gst_element_set_state (pipeline, GST_STATE_PLAYING);

}

void CameraWidget::on_ButtonPicture_clicked()
{
    gst_element_set_state (pipeline, GST_STATE_NULL);
    GstElement *picPipeline;
    picPipeline = gst_pipeline_new ("pipeline");
    QProcess process;

 // process.startDetached(" gst-launch v4l2src device=/dev/video0 num-buffers=1 ! dspjpegenc ! filesink location=/home/opt/phototranslator-alpha/poza.jpg");

    GstElement *src = gst_element_factory_make("v4l2src",NULL);

    g_object_set(G_OBJECT(src),
                 "num-buffers", "1 ",
                  NULL);

    GstElement *ffmpegcolorspace = gst_element_factory_make("ffmpegcolorspace",NULL);

    GstElement *jpeg = gst_element_factory_make("dspjpegenc",NULL);

    GstElement *filesink = gst_element_factory_make("filesink",NULL);

    g_object_set(G_OBJECT(filesink),
                "location", "/usr/share/doc/poza.jpg",
                NULL);

    gst_bin_add_many (GST_BIN (picPipeline), src, ffmpegcolorspace, jpeg,filesink, NULL);

    gst_element_link_many(src,ffmpegcolorspace, jpeg,filesink, NULL);

    gst_element_set_state(picPipeline, GST_STATE_PAUSED);

    gst_photography_set_white_balance_mode(GST_PHOTOGRAPHY(picPipeline), GST_PHOTOGRAPHY_WB_MODE_DAYLIGHT);
    gst_photography_set_colour_tone_mode(GST_PHOTOGRAPHY(picPipeline), GST_PHOTOGRAPHY_COLOUR_TONE_MODE_NATURAL);
    gst_photography_set_autofocus(GST_PHOTOGRAPHY(picPipeline), true);

    gst_element_set_state (picPipeline, GST_STATE_PLAYING);
    //---
    sleep(3);
    QString strFile = "/usr/share/doc/poza.jpg";
  //QString strFile = "/home/user/MyDocs/.images/poza.jpg";

    // Show image view
    View_Image* viewImage = new View_Image(m_context, this);
    viewImage->show();
    viewImage->initialize(strFile);

    process.startDetached("rm /home/opt/phototranslator-alpha/poza.jpg");
    gst_element_set_state (picPipeline, GST_STATE_NULL);

}

bool CameraWidget::event( QEvent * myEvent )
{

    QObjectList list = this->children();
    int nr = list.count();


     if( myEvent->type() == QEvent::ChildRemoved )
   {
       qDebug() << "ShowEvent: QEvent::ChildRemoved";

       gst_element_set_state (pipeline, GST_STATE_NULL);
       gst_object_unref (pipeline);
        if (list.count()==nr_children )
            {
                QTimer::singleShot( 100, this, SLOT( initialize() ) );
            }
        else if ( list.count()>nr_children )
            {
                return QEvent::None;
            }

         }

   return View::event( myEvent );
}


