//-----------------------------------------------------------------------------

#include <QWidget>
#include <QX11Info>
#include <X11/Xatom.h>

#include "hardkeyhandler_fremantle.h"


#include <QDebug>

//-----------------------------------------------------------------------------
HardkeyHandlerPrivate::HardkeyHandlerPrivate(HardkeyHandler* a_handler)
{
  qDebug() << "HardkeyHandlerPrivate::HardkeyHandlerPrivate(): Fremantle!";

  publicHandler = a_handler;
}

//-----------------------------------------------------------------------------
HardkeyHandlerPrivate::~HardkeyHandlerPrivate()
{
  qDebug() << "HardkeyHandlerPrivate::~HardkeyHandlerPrivate()";
}

//-----------------------------------------------------------------------------
bool HardkeyHandlerPrivate::processX11Event(XEvent* event)
{
    if ( event->type == KeyPress )
    {
        if (event->xkey.keycode == 73 || event->xkey.keycode == QKeySequence::ZoomOut)
        {
            emit publicHandler->decreaseKeyPressed();
            return true;
        }
        else if (event->xkey.keycode == 74  || event->xkey.keycode == QKeySequence::ZoomIn)
        {
            emit publicHandler->increaseKeyPressed();
            return true;
        }
    }

    return false;
}

//-----------------------------------------------------------------------------
void HardkeyHandlerPrivate::grabIncreaseDecreaseKeys(QWidget* window, bool grab)
{
    // Tell maemo-status-volume to grab/ungrab increase/decrease keys
    unsigned long val = (grab==true)?1:0;
    Atom atom;
    atom = XInternAtom( QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", 0);
    XChangeProperty (QX11Info::display(),
                     window->winId(),
                     atom,
                     XA_INTEGER,
                     32,
                     PropModeReplace,
                     (unsigned char *) &val,
                     1);

    if ( grab )
    {
        XGrabKey(QX11Info::display(),
                  QKeySequence::ZoomOut,
                  AnyModifier,
                  window->winId(),
                  True,
                  GrabModeAsync,
                  GrabModeAsync);

        XGrabKey(QX11Info::display(),
                  QKeySequence::ZoomIn,
                  AnyModifier,
                  window->winId(),
                  True,
                  GrabModeAsync,
                  GrabModeAsync);
    }
    else
    {
        /*XUngrabKey(QX11Info::display(),
                  73,
                  window->winId());

        XUngrabKey(QX11Info::display(),
                  74,
                  window->winId());*/
    }
}

//-----------------------------------------------------------------------------
