#include "dialog.h"
#include "ui_dialog.h"

#include <QtGui>

Dialog::Dialog( const QString &currentDirPath,
                QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);
    mCurrentDirPath = currentDirPath;

    ui->pushButton->setIcon( QIcon( ":/CustomDialog/up.png" ) );
    ui->pushButton_2->setIcon( QIcon( ":/CustomDialog/reload.png" ) );
    ui->pushButton_3->setIcon( QIcon( ":/CustomDialog/cancelSign.png" ) );
    //
    //  Is it posible to change the constructor of a promoted class?
    //
    ui->tableWidget->populateCustomTableWidget( currentDirPath );
    ui->label->setText( currentDirPath );

//    qDebug() << this->windowFlags();
//    this->overrideWindowFlags( this->windowFlags() ^ Qt::WindowTitleHint );
//    qDebug() << this->windowFlags();

    connect( ui->pushButton,
             SIGNAL(pressed()),
             ui->tableWidget,
             SLOT( tWcdUp() ) );

    connect( ui->pushButton_2,
             SIGNAL(pressed()),
             ui->tableWidget,
             SLOT( refreshTable() ) );

    connect( ui->tableWidget,
             SIGNAL(  pathUpdated( const QString &)),
             this,
             SLOT( updatePath(const QString &) ) );

    connect( ui->tableWidget,
             SIGNAL( pictureSelected( const QString &) ),
             this,
             SLOT( picturWasSelected( const QString &) ) );

    //
    //  Cancel Button added at Dragon Request!
    //
    connect( ui->pushButton_3,
             SIGNAL(clicked()),
             this,
             SLOT( close() ));


}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void
Dialog::updatePath( const QString & path )
{
    QFont font = this->font();
    QFontMetrics fontMetrix = QFontMetrics( font );

    //
    //  The magic number comes from dialog.ui ...
    //  The available space for the label.
    ui->label->setText(  fontMetrix.elidedText( path, Qt::ElideLeft, 350 ) );
}

void
Dialog::picturWasSelected( const QString & path )
{
    qDebug() << "selected picture in before emit:" << path;
    emit selectedPicturePath( path );
    qDebug() << "selected picture:" << path;    
}
