//-----------------------------------------------------------------------------
#include "Context.h"
//-----------------------------------------------------------------------------

#include "logic/OCR_Tesseract.h"
#include "logic/Translator_Google.h"
#include "settings/Settings.h"

#include <QDebug>

//-----------------------------------------------------------------------------
Context::Context(Application* a_application):
  m_application(a_application)
{
  qDebug() << "Context::Context()";

  // Get program install dir
  m_strProgramInstallDir = QDir::currentPath();
  qDebug() << "Context::Context(): install dir :" << m_strProgramInstallDir;

  // Make temp folder & set it to current working dir
  m_dirWorkingFolder = QDir::temp();
  m_dirWorkingFolder.mkdir("temp.photonslator.cybercom.com");
  m_dirWorkingFolder.cd("temp.photonslator.cybercom.com");
  QDir::setCurrent(m_dirWorkingFolder.absolutePath());
  qDebug() << "Context::Context(): current dir :" << m_dirWorkingFolder.absolutePath();

  // Create settings
  m_settings = new Settings(this);
  m_settings->load();

  // Create logic
  m_ocr = new OCR_Tesseract(this, m_strProgramInstallDir);
  m_translator = new Translator_Google(this);

  // Check supported languages
  QList<int> supportedSourceLang;
  QList<int> supportedTargetLang;
  {
    QList<int> ocrSuppors = m_ocr->supportedLanguages();
    QList<int> translatorSuppors = m_translator->supportedLanguages();
    for(int i = 0; i < ocrSuppors.size(); i++)
    {
      if(translatorSuppors.contains(ocrSuppors[i]))
        supportedSourceLang << ocrSuppors[i];
    }
    supportedTargetLang = translatorSuppors;
  }
  m_settings->setSupportedLangSource(supportedSourceLang);
  m_settings->setSupportedLangTarget(supportedTargetLang);

}

//-----------------------------------------------------------------------------
Context::~Context()
{
  qDebug() << "Context::~Context()";

  m_application = NULL;
}

//-----------------------------------------------------------------------------
Application* Context::application()
{
  return m_application;
}

//-----------------------------------------------------------------------------
Settings* Context::settings()
{
  return m_settings;
}

//-----------------------------------------------------------------------------
OCR* Context::ocr()
{
  return m_ocr;
}

//-----------------------------------------------------------------------------
Translator* Context::translator()
{
  return m_translator;
}

//-----------------------------------------------------------------------------
const QDir& Context::workingFolder() const
{
  return m_dirWorkingFolder;
}

//-----------------------------------------------------------------------------
const QString& Context::programInstallDir() const
{
  return m_strProgramInstallDir;
}

//-----------------------------------------------------------------------------
