#include "ocrlanguagesettings.h"
#include "ui_ocrlanguagesettings.h"
#include <QtGui>
#include "downloadfilemanager.h"

OCRLanguageSettings::OCRLanguageSettings(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::OCRLanguageSettings)
{
    createMyHashmap();
    this->mDownloadFileManager = new DownloadFileManager( this );

    ui->setupUi(this);

    ui->progressBar->hide();
    ui->cancelButton->hide();

    ui->listWidget->setSelectionMode( QAbstractItemView::NoSelection );
    ui->listWidget_2->setSelectionMode( QAbstractItemView::NoSelection );
    qDebug() << ui->listWidget->selectionMode();

    populateInstalledLanguages();
    populateAvailableLanguages();

    connect( this->ui->listWidget_2,
             SIGNAL( itemClicked ( QListWidgetItem *  ) ),
             this,
             SLOT( downloadLanguage( QListWidgetItem* )) );



    connect( this->mDownloadFileManager,
             SIGNAL( updateProgressBar( qint64 , qint64 )),
             this,
             SLOT( updateProgressBar(qint64 , qint64 ) ) );


    connect( this->ui->cancelButton,
             SIGNAL( clicked() ),
             this,
             SLOT( cancelDownload() ) );

    connect( this->mDownloadFileManager,
             SIGNAL( errorProcessed( const QString &)),
             this,
             SLOT(showError( const QString &)) );

    connect( this->mDownloadFileManager,
             SIGNAL(  downloadWasFinished()),
             this,
             SLOT(  downloadWasFinishedSlot()) );

    connect( this->mDownloadFileManager,
             SIGNAL(  fileWasSaved()),
             this,
             SLOT(  fileWasSavedSlot()) );

      ui->stackedWidget->setCurrentIndex( 1 );
      mMessageBox = new QMessageBox( this );
}

OCRLanguageSettings::~OCRLanguageSettings()
{
    delete ui;
    delete mDownloadFileManager;
    delete mMessageBox;
}

void OCRLanguageSettings::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void
OCRLanguageSettings::updateProgressBar(qint64 value, qint64 total)
{
    ui->progressBar->setValue( value );
    ui->progressBar->setMaximum( total );

//    if ( value )
//    {
//        if( ( value * 100 ) / total == 99 )
//        {
//            qint64 debugInt = ( value * 100 ) / total;
//            qDebug() << "cancel value: !!!" << debugInt ;
//            this->mDownloadFileManager->abortCurrentDownload();
//            downloadLanguage( new QListWidgetItem( "bul.traineddata" ) );
//        }
//
//    }
}

void
OCRLanguageSettings::cancelDownload()
{
   this->mDownloadFileManager->abortCurrentDownload();
}

void
OCRLanguageSettings::showError( const QString &stringError )
{
    disconnect( this->mDownloadFileManager,
             SIGNAL( errorProcessed( const QString &)),
             this,
             SLOT(showError( const QString &)) );

    mMessageBox->setWindowTitle( tr(" HTTP Error "));
    mMessageBox->setIcon( QMessageBox::Warning );
    mMessageBox->setText(tr("Error during download:   %1")
                    .arg(QString( stringError ) ));
    mMessageBox->show();


}

void
OCRLanguageSettings::populateInstalledLanguages()
{
    ui->listWidget->clear();
    QDir dir = QCoreApplication::applicationDirPath ();
    dir.cd( "tesseract" );
    dir.cd( "tessdata" );
    qDebug() << dir.absolutePath();

    QStringList nameFilters;
    nameFilters << "*.traineddata";

    dir.setNameFilters( nameFilters );

    QStringList fileList = dir.entryList();

    int fileListNo = fileList.size();

    if( !fileListNo )
    {
        return;
    }



    for( int i = 0; i < fileListNo; i++ )
    {
        QListWidgetItem *listItem = new QListWidgetItem( this->mMyHash.value( fileList.at(i) ) );
        listItem->setFlags( Qt::NoItemFlags );        
        ui->listWidget->insertItem( i, listItem );
    }
}

void
OCRLanguageSettings::populateAvailableLanguages()
{
    ui->listWidget_2->clear();
//    QStringList fileList;
//    fileList << "bul.traineddata"
//    << "cat.traineddata"
//    << "ces.traineddata"
//    << "chi_sim.traineddata"
//    << "chi_tra.traineddata"
//    << "dan.traineddata"
//    << "deu.traineddata"
//    << "ell.traineddata"
//    << "eng.traineddata"
//    << "fin.traineddata"
//    << "fra.traineddata"
//    << "hun.traineddata"
//    << "ind.traineddata"
//    << "ita.traineddata"
//    << "jpn.traineddata"
//    << "kor.traineddata"
//    << "lav.traineddata"
//    << "lit.traineddata"
//    << "nld.traineddata"
//    << "nor.traineddata"
//    << "osd.traineddata"
//    << "pol.traineddata"
//    << "por.traineddata"
//    << "ron.traineddata"
//    << "rus.traineddata"
//    << "slk.traineddata"
//    << "slv.traineddata"
//    << "spa.traineddata"
//    << "srp.traineddata"
//    << "swe.traineddata"
//    << "tgl.traineddata"
//    << "tha.traineddata"
//    << "tur.traineddata"
//    << "ukr.traineddata"
//    << "vie.traineddata";

    ui->listWidget_2->insertItems( 0 , this->mMyHash.values() );

}

void
OCRLanguageSettings::downloadLanguage( QListWidgetItem* listItem )
{
    disconnect( this->ui->listWidget_2,
             SIGNAL( itemClicked ( QListWidgetItem *  ) ),
             this,
             SLOT( downloadLanguage( QListWidgetItem* )) );

    QString lang = listItem->text();
    this->mDownloadFileManager->downloadFile( this->mMyHash.key( lang ) );

    connect( this->mDownloadFileManager,
             SIGNAL( errorProcessed( const QString &)),
             this,
             SLOT(showError( const QString &)) );

    ui->stackedWidget->setCurrentIndex( 0 );
    lang = "Adding Language:  " + lang + "        %p%";
    ui->progressBar->setFormat( lang );
    ui->progressBar->show();
    ui->cancelButton->show();
}

void
OCRLanguageSettings::downloadWasFinishedSlot()
{
    connect( this->ui->listWidget_2,
             SIGNAL( itemClicked ( QListWidgetItem *  ) ),
             this,
             SLOT( downloadLanguage( QListWidgetItem* )) );
    ui->stackedWidget->setCurrentIndex( 1 );
    ui->progressBar->hide();
    ui->cancelButton->hide();
    ui->progressBar->setValue( 0 );

}

void
OCRLanguageSettings::createMyHashmap()
{
    this->mMyHash.insert( "bul.traineddata","Bulgarian [2Mb]" );
    this->mMyHash.insert( "cat.traineddata", "Catalan [2Mb]" );
    this->mMyHash.insert( "ces.traineddata", "Czech [2Mb]" );
    this->mMyHash.insert( "chi_sim.traineddata", "Chinese(Simplified) [41Mb]" );
    this->mMyHash.insert( "chi_tra.traineddata", "Chinese(Traditional) [56Mb]" );
    this->mMyHash.insert( "dan.traineddata", "Danish [2Mb]" );
    this->mMyHash.insert( "deu.traineddata", "German [2Mb]" );
    this->mMyHash.insert( "ell.traineddata", "Greek [2Mb]" );
    this->mMyHash.insert( "eng.traineddata", "English [2Mb]" );
    this->mMyHash.insert( "fin.traineddata", "Finnish [2Mb]" );
    this->mMyHash.insert( "fra.traineddata", "French [2Mb]" );
    this->mMyHash.insert( "hun.traineddata", "Hungarian [2Mb]" );
    this->mMyHash.insert( "ind.traineddata", "Indonesian [2Mb]" );
    this->mMyHash.insert( "ita.traineddata", "Italian [2Mb]" );
    this->mMyHash.insert( "jpn.traineddata", "Japanese [30Mb]" );
    this->mMyHash.insert( "kor.traineddata", "Korean [13Mb]" );
    this->mMyHash.insert( "lav.traineddata", "Latvian [2Mb]" );
    this->mMyHash.insert( "lit.traineddata", "Lithuanian [2Mb]" );
    this->mMyHash.insert( "nld.traineddata", "Dutch [2Mb]" );
    this->mMyHash.insert( "nor.traineddata", "Norwegian [2Mb]" );
    this->mMyHash.insert( "osd.traineddata", "OSD [0Mb]" );
    this->mMyHash.insert( "pol.traineddata", "Polish [2Mb]" );
    this->mMyHash.insert( "por.traineddata", "Portuguese [2Mb]" );
    this->mMyHash.insert( "ron.traineddata", "Romanian. [2Mb]" );
    this->mMyHash.insert( "rus.traineddata", "Russian [2Mb]" );
    this->mMyHash.insert( "slk.traineddata", "Slovak [2Mb]" );
    this->mMyHash.insert( "slv.traineddata", "Slovenian [2Mb]" );
    this->mMyHash.insert( "spa.traineddata", "Spanish [2Mb]" );
    this->mMyHash.insert( "srp.traineddata", "SRP [2Mb]" );
    this->mMyHash.insert( "swe.traineddata", "Swedish [2Mb]" );
    this->mMyHash.insert( "tgl.traineddata", "TGL [2Mb]" );
    this->mMyHash.insert( "tha.traineddata", "Thailand [0Mb]" );
    this->mMyHash.insert( "tur.traineddata", "Thurkis [2Mb]" );
    this->mMyHash.insert( "ukr.traineddata", "Ukrainian [2Mb]" );
    this->mMyHash.insert( "vie.traineddata", "Vietnamese [3Mb]" );
}

void
OCRLanguageSettings::hideEvent ( QHideEvent */* event */ )
{
    this->mDownloadFileManager->abortCurrentDownload();
}
