#ifndef OCR_TESSERACT_H
#define OCR_TESSERACT_H
//-----------------------------------------------------------------------------

#include "OCR.h"

#include <QMap>
#include <QProcess>

//-----------------------------------------------------------------------------
class OCR_Tesseract:
  public OCR
{
  Q_OBJECT

  public:
    OCR_Tesseract(QObject* a_parent, const QString& a_strProgramInstallDir);
    ~OCR_Tesseract();

  public:
    virtual QList<int> supportedLanguages() const;

  public slots:
    virtual void run(const QString& a_image, int a_lang);
    virtual bool cancel();

  protected slots:
    void processDone(int a_exitCode);
    void processError(QProcess::ProcessError a_error);

  protected:
    QProcess* m_process;

    QMap<int, QString> m_mapLanguage;

    QString m_strProgramInstallDir;

    bool m_cancelled;
};

//-----------------------------------------------------------------------------
#endif // OCR_TESSERACT_H
