#include "CameraWidget.h"
#include "ui_CameraWidget.h"

#include "Context.h"
#include "Definitions.h"
#include "View.h"
#include "View_Image.h"

#include <QDebug>
#include <QWidget>
#include <QMessageBox>
#include <QProcess>

#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
//#include <gst/interfaces/photography.h>
#include "glib.h"

#include <QTimer>

CameraWidget::CameraWidget(Context* a_context, QWidget* a_parent):
  View(a_context, a_parent),
  m_ui(new Ui::CameraWidget)
{
  qDebug() << "CameraWidget::CameraWidget()";
  m_ui->setupUi(this);
  QTimer::singleShot( 100, this, SLOT( initialize() ) );

}

CameraWidget::~CameraWidget()
{
	m_ui->widget->hide();
	gst_element_set_state (pipeline, GST_STATE_NULL);
	gst_object_unref (pipeline);
}

void CameraWidget::initialize()
{
    QObjectList list = this->children();
    nr_children = list.count();

    qDebug() << "CameraWidget::initialize()" ;

    WId xwinid = m_ui->widget->winId();

    src = gst_element_factory_make ("v4l2src", NULL);//, videotestsrc

    vscale = gst_element_factory_make ("videoscale", NULL);//, videotestsrc

    sink= gst_element_factory_make ("xvimagesink", NULL);

    pipeline = gst_pipeline_new ("xvoverlay");

    gst_bin_add_many (GST_BIN (pipeline), src, vscale, sink, NULL);

    gst_element_link_many (src,vscale, sink, NULL);

    QApplication::syncX();

    gst_x_overlay_set_xwindow_id (GST_X_OVERLAY (sink), (gulong)(xwinid));

    gst_element_set_state (pipeline, GST_STATE_NULL);

    gst_element_set_state (pipeline, GST_STATE_PLAYING);

}

void CameraWidget::on_ButtonPicture_clicked()
{
  //  m_process.startDetached(" gst-launch v4l2camsrc device=/dev/video0 num-buffers=1 ! dspjpegenc ! filesink location=/usr/share/doc/poza.jpg");
    gst_element_set_state (pipeline, GST_STATE_NULL);

    QProcess process;

    process.startDetached(" gst-launch v4l2src device=/dev/video0 num-buffers=1 ! dspjpegenc ! filesink location=/usr/share/doc/poza.jpg");

    sleep(3);
 //   QString strFile = "/usr/share/doc/poza.jpg";
    QString strFile = "/home/opt/phototranslator-alpha/poza.jpg";

    // Show image view
    View_Image* viewImage = new View_Image(m_context, this);

    viewImage->show();
    viewImage->initialize(strFile);

    process.close();

    process.startDetached("rm /home/opt/phototranslator-alpha/poza.jpg");
}

bool CameraWidget::event( QEvent * myEvent )
{

    QObjectList list = this->children();
    int nr = list.count();


     if( myEvent->type() == QEvent::ChildRemoved )
   {
       qDebug() << "ShowEvent: QEvent::ChildRemoved";

       gst_element_set_state (pipeline, GST_STATE_NULL);
       gst_object_unref (pipeline);
        if (list.count()==nr_children )
            {
                QTimer::singleShot( 100, this, SLOT( initialize() ) );
            }
        else if ( list.count()>nr_children )
            {
                return QEvent::None;
            }

         }

   return View::event( myEvent );
}


