#include "downloadfilemanager.h"
#include <QtGui>
#include <QtNetwork>
#include <QMessageBox>

const QString DownloadFileManager::baseServerAddress = "http://www.cybercomchannel.com/blog/photo-translator/languages/";

DownloadFileManager::DownloadFileManager(QObject *parent) :
    QObject(parent)
{
    this->mNetworkManager = new QNetworkAccessManager( this );

    connect( this->mNetworkManager, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(downloadFinished(QNetworkReply*)));

    this->mNetworkReply = 0;
    mMessageBox = new QMessageBox();
}

DownloadFileManager::~DownloadFileManager()
{
    qDebug() << "DownloadFileManager::~DownloadFileManager()";
    if( mNetworkReply )
    {
        mNetworkReply->abort();
        mNetworkReply->deleteLater();
        qDebug() << "!!!!!!!DownloadFileManager::~DownloadFileManager()";
    }

    this->mNetworkManager->deleteLater();
    delete mMessageBox;
}

void
DownloadFileManager::downloadFile( const QString &fileName )
{

    this->file = fileName;
    QNetworkRequest request;
    request.setUrl( QUrl( baseServerAddress + "/" + fileName ) );
    request.setRawHeader( "User-Agent", "MyOwnBrowser 1.0" );

    this->mNetworkReply = this->mNetworkManager->get( request );

    connect( this->mNetworkReply,
             SIGNAL( downloadProgress(qint64, qint64)),
             this,
             SIGNAL( updateProgressBar(qint64, qint64)) );

    connect( this->mNetworkReply,
             SIGNAL( error(  QNetworkReply::NetworkError )),
             this,
             SLOT(  processError( QNetworkReply::NetworkError ) ) );

}

void
DownloadFileManager::downloadFinished(QNetworkReply */* networkReply */ )
{
    //
    //  Error Check
    //
    emit downloadWasFinished();

    if( this->mNetworkReply && this->mNetworkReply->error()  )
    {
        QString stringError = this->mNetworkReply->errorString();
        this->mNetworkReply->deleteLater();
        this->mNetworkReply = 0;
        emit errorProcessed( stringError );
        return;
    }

    //
    //  read all the info from the network reply
    //
    QByteArray data = this->mNetworkReply->readAll();
    this->mNetworkReply->deleteLater();
    this->mNetworkReply = 0;

    //  TODO: path for savedFile.
    QFile *file = new QFile( QCoreApplication::applicationDirPath () + QDir::separator() + "tesseract" + QDir::separator() + "tessdata" + QDir::separator() + this->file );
    if (!file->open(QIODevice::WriteOnly))
    {
        mMessageBox->setWindowTitle( tr(" Saving file... "));
        mMessageBox->setIcon( QMessageBox::Critical );
        mMessageBox->setText( tr("Unable to save the file %1: %2.")
                         .arg( file->fileName() ).arg(file->errorString()) );
        mMessageBox->show();
        delete file;
        file = 0;
        return;
    }

    //
    //  write data in File
    //
    QDataStream outFileStream( file );
    outFileStream.setVersion(QDataStream::Qt_4_0);
    outFileStream.writeRawData( data.data(), data.length() );
    file->close();
    qDebug() << "file was Saved!";


    mMessageBox->setWindowTitle( tr(" Saving file... "));
    mMessageBox->setIcon( QMessageBox::Information );
    mMessageBox->setText( tr("File saved:   %1")
                     .arg( this->file ) );
    mMessageBox->show();

    emit fileWasSaved();
}

void
DownloadFileManager::processError( QNetworkReply::NetworkError /*code*/ )
{
//    QString errorString = this->mNetworkReply->errorString();
//    if( this->mNetworkReply )
//    {
//        emit errorProcessed( errorString  );
//    }
//
//      The network reply should not be deleted
//      It will be done in the finished slot;

}

void
DownloadFileManager::abortCurrentDownload()
{
    if( this->mNetworkReply )
    {        
        this->mNetworkReply->abort();
    }
}


