//-----------------------------------------------------------------------------
#include "hardkeyhandler.h"
//-----------------------------------------------------------------------------

#ifdef Q_OS_FREMANTLE
#include "hardkeyhandler_fremantle.h"
#else
#include "hardkeyhandler_stub.h"
#endif

#include <QDebug>

//-----------------------------------------------------------------------------
HardkeyHandler::HardkeyHandler(QObject* a_parent):
  QObject(a_parent)
{
  d_ptr = new HardkeyHandlerPrivate(this);
}

//-----------------------------------------------------------------------------
HardkeyHandler::~HardkeyHandler()
{
  qDebug() << "HardkeyHandler::~HardkeyHandler(): start";
  delete d_ptr;
  qDebug() << "HardkeyHandler::~HardkeyHandler(): begin";
}

//-----------------------------------------------------------------------------
#ifdef Q_WS_X11
bool HardkeyHandler::processX11Event(XEvent* event)
{
  return d_ptr->processX11Event(event);
}
#endif

//-----------------------------------------------------------------------------
void HardkeyHandler::grabIncreaseDecreaseKeys(QWidget* window, bool grab)
{
  d_ptr->grabIncreaseDecreaseKeys(window, grab);
}

//-----------------------------------------------------------------------------
