#ifndef OCR_H
#define OCR_H
//-----------------------------------------------------------------------------

#include <QObject>

//-----------------------------------------------------------------------------
class OCR:
  public QObject
{
  Q_OBJECT

  public:
    OCR(QObject* a_parent);
    ~OCR();

  public:
    virtual QList<int> supportedLanguages() const = 0;

  signals:
    void done(QString a_text);
    void error(QString a_error);

  public slots:
    virtual void run(const QString& a_image, int a_lang) = 0;
    virtual bool cancel() = 0;
};

//-----------------------------------------------------------------------------
#endif // OCR_H
