//-----------------------------------------------------------------------------
#include "LanguageDialog.h"
//-----------------------------------------------------------------------------

#include "common/Language.h"

#include <QHBoxLayout>
#include <QPushButton>
#include <QScrollArea>
#include <QSignalMapper>
#include <QVariant>
#include <QVBoxLayout>

/*#ifdef Q_WS_MAEMO_5
  #include <QtMaemo5/QMaemo5KineticScroller>
#endif
*/

#include <QDebug>

//-----------------------------------------------------------------------------
LanguageDialog::LanguageDialog(QWidget* a_parent, const QList<int>& a_lang):
  QDialog(a_parent)
{
  QWidget* widgetContent = new QWidget();
  QVBoxLayout* layoutContent = new QVBoxLayout(widgetContent);
  QSignalMapper* mapper = new QSignalMapper(this);
  for(int iLang = 0; iLang < a_lang.size(); iLang++)
  {
    QPushButton* button = new QPushButton(Language::toString(a_lang[iLang]), widgetContent);
    connect(button, SIGNAL(clicked()), mapper, SLOT(map()));
    mapper->setMapping(button, a_lang[iLang]);
    layoutContent->addWidget(button);
  }
  connect(mapper, SIGNAL(mapped(int)), this, SLOT(clicked(int)));

  QScrollArea* scroll = new QScrollArea(this);
  scroll->setWidgetResizable(true);
 /* #ifdef Q_WS_MAEMO_5
    new QMaemo5KineticScroller(scroll);
  #else
  */
    scroll->setProperty("FingerScrollable", true);
 // #endif
  scroll->setWidget(widgetContent);

  QHBoxLayout* layoutThis = new QHBoxLayout(this);
  layoutThis->addWidget(scroll);
}

//-----------------------------------------------------------------------------
LanguageDialog::~LanguageDialog()
{
}

//-----------------------------------------------------------------------------
void LanguageDialog::clicked(int a_lang)
{
  done(a_lang);
}

//-----------------------------------------------------------------------------
