#ifndef CTWORKINGTHREAD_H
#define CTWORKINGTHREAD_H

#include <QThread>
#include <QString>
#include <QStringList>
#include <QImage>
#include <QHash>

class CustomTableWidget;


class CTWorkingThread : public QThread
{
Q_OBJECT
public:
    explicit CTWorkingThread( QObject *parent = 0 );
    void
    prepairToStart(const QString &path,
                   const QStringList &fileList );


signals:
    void
    imageProcessed( int i,
                    int j,
                    const QImage &image);

public slots:

protected slots:
    virtual void
            run();

private:
    QImage returnThumbnailPicture(const QString &path );

private:
    QString path;
    CustomTableWidget *tableWidget;
    QStringList fileList;

    QHash< QString, QImage > savedImages;

};

#endif // CTWORKINGTHREAD_H
