#ifndef VIEW_IMAGE_H
#define VIEW_IMAGE_H
//-----------------------------------------------------------------------------

#include "View.h"

//-----------------------------------------------------------------------------
class ImageScrollView;
class ImageWidget;

class QPushButton;

//-----------------------------------------------------------------------------
namespace Ui
{
  class View_Image;
}

//-----------------------------------------------------------------------------
class View_Image:
  public View
{
  Q_OBJECT

  public:
    View_Image(Context* a_context, QWidget* a_parent = NULL);
    ~View_Image();

  public:
    void initialize(const QString& a_pathPicture);

  public slots:
    void onTranslate();

    void onSourceLang();
    void onSettingsChanged(quint32 a_changed);

  protected:
    virtual void keyReleaseEvent(QKeyEvent* a_event);

  protected slots:
    void refreshLanguageButtons();

  private:
    Ui::View_Image* m_ui;

    ImageScrollView* m_widgetScroll;
    ImageWidget* m_widgetImage;

    QPushButton* m_buttonSourceLang;
};

//-----------------------------------------------------------------------------
#endif // VIEW_IMAGE_H
