//-----------------------------------------------------------------------------
#include "SettingsDialog.h"
#include "ui_SettingsDialog.h"
//-----------------------------------------------------------------------------

#include "LanguageDialog.h"
#include "Settings.h"
#include "common/Language.h"

#include <QPushButton>

#ifdef Q_WS_MAEMO_5
  #include <QtMaemo5/QMaemo5ValueButton>
#endif

#include <QDebug>

//-----------------------------------------------------------------------------
SettingsDialog::SettingsDialog(QWidget* a_parent):
  QDialog(a_parent),
  m_ui(new Ui::SettingsDialog)
{
  m_ui->setupUi(this);

  QString strSourceLabel(tr("Source language"));
  QString strTargetLabel(tr("Target language"));
  m_buttonSourceLang = NULL;
  m_buttonTargetLang = NULL;
  #ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton* buttonSourceLang = new QMaemo5ValueButton(strSourceLabel, this);
    buttonSourceLang->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    m_buttonSourceLang = buttonSourceLang;
    QMaemo5ValueButton* buttonTargetLang = new QMaemo5ValueButton(strTargetLabel, this);
    buttonTargetLang->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    m_buttonTargetLang = buttonTargetLang;
  #else
    m_buttonSourceLang = new QPushButton(strSourceLabel, this);
    m_buttonTargetLang = new QPushButton(strTargetLabel, this);
  #endif
  m_ui->layout->addWidget(m_buttonSourceLang);
  m_ui->layout->addWidget(m_buttonTargetLang);

  connect(m_buttonSourceLang, SIGNAL(clicked()), this, SLOT(onLangSource()));
  connect(m_buttonTargetLang, SIGNAL(clicked()), this, SLOT(onLangTarget()));

  m_settings = NULL;
}

//-----------------------------------------------------------------------------
SettingsDialog::~SettingsDialog()
{
  delete m_ui;
}

//-----------------------------------------------------------------------------
void SettingsDialog::initialize(Settings* a_settings)
{
  if(!a_settings)
  {
    qDebug() << "ERROR: SettingsDialog::initialize(): a_settings == NULL";
    return;
  }

  setSourceLangText(a_settings->langSource());
  setTargetLangText(a_settings->langTarget());

  m_settings = a_settings;
}

//-----------------------------------------------------------------------------
void SettingsDialog::onLangSource()
{
  if(!m_settings)
    return;

  LanguageDialog dialog(this, m_settings->supportedLangSource());
  dialog.setWindowTitle(tr("Select source language"));
  int language = dialog.exec();
  if(language > 0)
  {
    m_settings->setLangSource(language);
    setSourceLangText(language);
  }
}

//-----------------------------------------------------------------------------
void SettingsDialog::onLangTarget()
{
  if(!m_settings)
    return;

  LanguageDialog dialog(this, m_settings->supportedLangTarget());
  dialog.setWindowTitle(tr("Select target language"));
  int language = dialog.exec();
  if(language > 0)
  {
    m_settings->setLangTarget(language);
    setTargetLangText(language);
  }
}

//-----------------------------------------------------------------------------
void SettingsDialog::setSourceLangText(int a_lang)
{
  #ifdef Q_WS_MAEMO_5
    if(QMaemo5ValueButton* button = qobject_cast<QMaemo5ValueButton*>(m_buttonSourceLang))
      button->setValueText(Language::toString(a_lang));
  #else
    QString strSourceLabel(tr("Source language"));
    m_buttonSourceLang->setText(strSourceLabel + QString(": ") + Language::toString(a_lang));
  #endif
}

//-----------------------------------------------------------------------------
void SettingsDialog::setTargetLangText(int a_lang)
{
  #ifdef Q_WS_MAEMO_5
    if(QMaemo5ValueButton* button = qobject_cast<QMaemo5ValueButton*>(m_buttonTargetLang))
      button->setValueText(Language::toString(a_lang));
  #else
    QString strTargetLabel(tr("Target language"));
    m_buttonTargetLang->setText(strTargetLabel + QString(": ") + Language::toString(a_lang));
  #endif
}

//-----------------------------------------------------------------------------
void SettingsDialog::changeSourceLanguage(QWidget* a_parent, Settings* a_settings)
{
  if(!a_parent || !a_settings)
    return;

  LanguageDialog dialog(a_parent, a_settings->supportedLangSource());
  dialog.setWindowTitle(tr("Select source language"));
  int language = dialog.exec();
  if(language > 0)
  {
    a_settings->setLangSource(language);
    a_settings->save();
  }
}

//-----------------------------------------------------------------------------
void SettingsDialog::changeTargetLanguage(QWidget* a_parent, Settings* a_settings)
{
  if(!a_parent || !a_settings)
    return;

  LanguageDialog dialog(a_parent, a_settings->supportedLangTarget());
  dialog.setWindowTitle(tr("Select target language"));
  int language = dialog.exec();
  if(language > 0)
  {
    a_settings->setLangTarget(language);
    a_settings->save();
  }
}

//-----------------------------------------------------------------------------
