//-----------------------------------------------------------------------------
#include "View_Start.h"
#include "ui_View_Start.h"
//-----------------------------------------------------------------------------

#include "Context.h"
#include "View_Image.h"
#include "View_Translate.h"
#include "settings/Settings.h"
//#include "CameraWidget.h"

#include <QFileDialog>
#include <QDateTime>

#include <QDebug>

#include <customDialog/dialog.h>

//-----------------------------------------------------------------------------
View_Start::View_Start(Context* a_context, QWidget* a_parent):
  View(a_context, a_parent),
  m_ui(new Ui::View_Start)
{
  qDebug() << "View_Start::View_Start()";

  m_ui->setupUi(this);
  m_ui->camera->hide();
}

//-----------------------------------------------------------------------------
View_Start::~View_Start()
{
  qDebug() << "View_Start::~View_Start()";

  delete m_ui;
}

//-----------------------------------------------------------------------------
void View_Start::initialize()
{
}

//-----------------------------------------------------------------------------
void View_Start::on_translate_clicked()
{
  // Show translate view
  View_Translate* viewTranslate = new View_Translate(m_context, this);
  viewTranslate->initialize(false);
  viewTranslate->show();
}

//-----------------------------------------------------------------------------
void View_Start::on_open_clicked()
{
  qDebug() << "View_Start::on_open_clicked()";

  QString strPath;// = QDir::homePath();

  QString strPathPrevious = m_context->settings()->openDir();
  QDir dirPathPrevious(strPathPrevious);
  if(!strPathPrevious.isEmpty() && dirPathPrevious.exists())
    {
    qDebug() << "open previous saved path" << dirPathPrevious.absolutePath();
    strPath = dirPathPrevious.absolutePath();
    }
  else
  {
//    qDebug() << "View_Start::on_open_clicked(): failed directory =" << dirPathPrevious;
//
//    QString strPathDCIM("/media/mmc1/DCIM");
//    QDir dirDCIM(strPathDCIM);
//    if(dirDCIM.exists())
//      strPath = dirDCIM.absolutePath();
//    else
//    {
//      qDebug() << "View_Start::on_open_clicked(): failed directory =" << strPathDCIM;
//
//      QString strPathImages = QDir::homePath() + QString("/MyDocs/.images");
//      QDir dirImages(strPathImages);
//      if(dirImages.exists())
//        strPath = dirImages.absolutePath();
//      else
//      {
//        qDebug() << "View_Start::on_open_clicked(): failed directory =" << strPathImages;
//
//        QString strPathData = m_context->programInstallDir() + QString("/data/");
//        QDir dirData(strPathData);
//        if(dirData.exists())
//          strPath = dirData.absolutePath();
//        else
//          qDebug() << "View_Start::on_open_clicked(): failed directory =" << strPathData;
//      }
//    }
      QDir cardPicturePath( "/media/mmc1/DCIM" );
      QDir phonePicturePath( "/home/user/MyDocs/DCIM" );

      if( !cardPicturePath.exists() )
      {
          if( !phonePicturePath.exists() )
              strPath = "/home/user/MyDocs/.images";
          else
              strPath = phonePicturePath.absolutePath();

      }
      else
      {
          if( !phonePicturePath.exists() )
          {
              strPath = cardPicturePath.absolutePath();
          }
          else
          {
             QFileInfoList infoCardPath =cardPicturePath.entryInfoList( QDir::Files | QDir::NoDotAndDotDot, QDir::Time );
             QFileInfoList infoPhonePath = phonePicturePath.entryInfoList( QDir::Files | QDir::NoDotAndDotDot, QDir::Time );

              if( infoCardPath.size() == 0 )
                  strPath = phonePicturePath.absolutePath();

              if( infoPhonePath.size() == 0 )
                  {
                  strPath = cardPicturePath.absolutePath();
                  }

              if( strPath.isEmpty() )
              {
                  if( infoCardPath.at(0).created() >
                      infoPhonePath.at(0).created() )
                  {
                      strPath = cardPicturePath.absolutePath();
                  }
                  else
                  {
                      strPath = phonePicturePath.absolutePath();
                  }
              }

          }
      }

  }

  //
  //  DoubleCheck if something went wrong
  //
  if ( strPath.isEmpty() )
      strPath = "/home/user/MyDocs/.images";

  qDebug() << "View_Start::on_open_clicked(): open directory =" << strPath;

//  QString strFile = QFileDialog::getOpenFileName( this, tr("Open picture"), strPath,
//                                                  tr("Images (*.png *.jpg *.tif)") );


  //
  //    Open Custom Dialog
  //
  customDialog = new Dialog( strPath, this );
  connect( this->customDialog,
           SIGNAL( selectedPicturePath( const QString &) ),
           this,
           SLOT( picturePicked( const QString &) ) );

  connect( this->customDialog,
           SIGNAL( rejected( ) ),
           this,
           SLOT( dialogRejected() ) );


  customDialog->exec();

//  if(strFile.isNull())
//  {
//    qDebug() << "View_Start::on_open_clicked(): Cancelled";
//    return;
//  }


}

//-----------------------------------------------------------------------------
//void View_Start::on_camera_clicked()
//{
//    qDebug() << "View_Start::on_camera_clicked()";
//
//    CameraWidget* camera = new CameraWidget(m_context, this);
//    camera->show();
//  //  camera->initialize();
//
//
//}


//-----------------------------------------------------------------------------

void
View_Start::picturePicked( const QString &strFile )
{
    qDebug() << "View_Start::on_open_clicked(): open file =" << strFile;

    // Save path to settings
    QDir dirOpened(strFile.left(strFile.lastIndexOf(QRegExp("[\\\\/]"))));
    m_context->settings()->setOpenDir(dirOpened.absolutePath());
    m_context->settings()->save();

    // Show image view
    viewImage = new View_Image(m_context, this);
    viewImage->show();

    this->strFile = strFile;
    QTimer::singleShot( 50, this, SLOT( initPicture() ) );

    qDebug() << "delete dialog on picturePicked slot";
    customDialog->deleteLater();
}
void
View_Start::dialogRejected()
{
    qDebug() << "dialog rejected delete dialog";
    customDialog->deleteLater();

}

void
View_Start::initPicture()
{
    viewImage->initialize( this->strFile );
}

