#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H
//-----------------------------------------------------------------------------

#include <QDialog>

//-----------------------------------------------------------------------------
class Settings;
class QPushButton;

//-----------------------------------------------------------------------------
namespace Ui
{
  class SettingsDialog;
}

//-----------------------------------------------------------------------------
class SettingsDialog:
  public QDialog
{
  Q_OBJECT

  public:
    static void changeSourceLanguage(QWidget* a_parent, Settings* a_settings);
    static void changeTargetLanguage(QWidget* a_parent, Settings* a_settings);

  public:
    SettingsDialog(QWidget* a_parent = 0);
    ~SettingsDialog();

    void initialize(Settings* a_settings);

  protected slots:
    void onLangSource();
    void onLangTarget();

    void setSourceLangText(int a_lang);
    void setTargetLangText(int a_lang);

  private:
    Ui::SettingsDialog* m_ui;

    Settings* m_settings;

    QPushButton* m_buttonSourceLang;
    QPushButton* m_buttonTargetLang;
};

//-----------------------------------------------------------------------------
#endif // SETTINGSDIALOG_H
