#ifndef TRANSLATOR_H
#define TRANSLATOR_H
//-----------------------------------------------------------------------------

#include <QObject>

//-----------------------------------------------------------------------------
class Translator:
  public QObject
{
  Q_OBJECT

  public:
    Translator(QObject* a_parent);
    ~Translator();

  public:
    virtual QList<int> supportedLanguages() const = 0;

  signals:
    void done(QString a_text);
    void error(QString a_error);

  public slots:
    virtual void run(const QString& a_text, int a_langFrom, int a_langTo) = 0;
    virtual bool cancel() = 0;
};

//-----------------------------------------------------------------------------
#endif // TRANSLATOR_H
