#ifndef BUSYWIDGET_H
#define BUSYWIDGET_H
//-----------------------------------------------------------------------------

#include <QWidget>

#include <QTimer>

//-----------------------------------------------------------------------------
class BusyWidget:
  public QWidget
{
  Q_OBJECT

  public:
    BusyWidget(QWidget* a_parent = 0);
    ~BusyWidget();

  protected slots:
    void onTimeout();

  protected:
    virtual void hideEvent(QHideEvent* a_event);
    virtual void showEvent(QShowEvent* a_event);

    virtual void paintEvent(QPaintEvent* a_event);

  private:
    QTimer m_timer;

    int m_blocks;
    int m_current;
    qreal m_maxBoxSize;
};

//-----------------------------------------------------------------------------
#endif // BUSYWIDGET_H
