//-----------------------------------------------------------------------------
#include "OCR_Tesseract.h"
//-----------------------------------------------------------------------------

#include "common/Language.h"

#include <QFile>
#include <QTextCodec>

#include <QDebug>

//-----------------------------------------------------------------------------
const QString
    OCR_Tesseract::tesseractTextFilePath = QString( "/home/opt/phototranslator-alpha/text.txt" );

const QString
    OCR_Tesseract::tesseractTextFilePathNoExtension = QString( "/home/opt/phototranslator-alpha/text" );


OCR_Tesseract::OCR_Tesseract(QObject* a_parent, const QString& a_strProgramInstallDir):
  OCR(a_parent),
  m_strProgramInstallDir(a_strProgramInstallDir)
{
  m_process = NULL;
  m_cancelled = false;

  // Map languages
  m_mapLanguage.insert(int(Language_Bulgarian), "bul");
  m_mapLanguage.insert(int(Language_Catalan), "cat");
  m_mapLanguage.insert(int(Language_Chinese_Simplified), "chi_sim");
  m_mapLanguage.insert(int(Language_Chinese_Traditional), "chi_tra");
  m_mapLanguage.insert(int(Language_Danish), "dan");
  m_mapLanguage.insert(int(Language_German), "deu");
  m_mapLanguage.insert(int(Language_Greek), "ell");
  m_mapLanguage.insert(int(Language_English), "eng");
  m_mapLanguage.insert(int(Language_Finnish), "fin");
  m_mapLanguage.insert(int(Language_French), "fra");
  m_mapLanguage.insert(int(Language_Hungarian), "hun");
  m_mapLanguage.insert(int(Language_Indonesian), "ind");
  m_mapLanguage.insert(int(Language_Italian), "ita");
  m_mapLanguage.insert(int(Language_Japanese), "jpn");
  m_mapLanguage.insert(int(Language_Korean), "kor");
  m_mapLanguage.insert(int(Language_Latvian), "lav");
  m_mapLanguage.insert(int(Language_Lithuanian), "lit");
  m_mapLanguage.insert(int(Language_Dutch), "nld");
  m_mapLanguage.insert(int(Language_Norwegian), "nor");
  m_mapLanguage.insert(int(Language_Polish), "pol");
  m_mapLanguage.insert(int(Language_Portuguese), "por");
  m_mapLanguage.insert(int(Language_Romanian), "ron");
  m_mapLanguage.insert(int(Language_Russian), "rus");
  m_mapLanguage.insert(int(Language_Slovak), "slk");
  m_mapLanguage.insert(int(Language_Slovenian), "slv");
  m_mapLanguage.insert(int(Language_Spanish), "spa");
  m_mapLanguage.insert(int(Language_Serbian), "srp");
  m_mapLanguage.insert(int(Language_Swedish), "swe");
  m_mapLanguage.insert(int(Language_Galician), "tgl"); //?
//  m_mapLanguage.insert(int(Language_Thai), "tha");
  m_mapLanguage.insert(int(Language_Turkish), "tur");
  m_mapLanguage.insert(int(Language_Ukrainian), "ukr");
  m_mapLanguage.insert(int(Language_Vietnamese), "vie");

/*
  osd
  m_mapLanguage.insert(int(Language_Albanian), "sq");
  m_mapLanguage.insert(int(Language_Arabic), "ar");
  m_mapLanguage.insert(int(Language_Croatian), "hr");
  m_mapLanguage.insert(int(Language_Czech), "cz");
  m_mapLanguage.insert(int(Language_Estonian), "et");
  m_mapLanguage.insert(int(Language_Filipino), "tl");
  m_mapLanguage.insert(int(Language_Hebrew), "iw");
  m_mapLanguage.insert(int(Language_Hindi), "hi");
  m_mapLanguage.insert(int(Language_Maltese), "mt");
*/
}

//-----------------------------------------------------------------------------
OCR_Tesseract::~OCR_Tesseract()
{
  if(m_process)
    delete m_process;
  m_process = NULL;
}

//-----------------------------------------------------------------------------
QList<int> OCR_Tesseract::supportedLanguages() const
{
  return m_mapLanguage.keys();
}

//-----------------------------------------------------------------------------
void OCR_Tesseract::run(const QString& a_image, int a_lang)
{
  qDebug() << "OCR_Tesseract::run(" << a_image << "," << a_lang << ")";

  if(m_process)
  {
    qDebug() << "OCR_Tesseract::run(): Old process still existing!!!";
    m_process->deleteLater();
  }
  m_cancelled = false;
  m_process = new QProcess(this);
  connect(m_process, SIGNAL(finished(int)), this, SLOT(processDone(int)));
  connect(m_process, SIGNAL(error(QProcess::ProcessError)), this, SLOT(processError(QProcess::ProcessError)));

  QStringList listEnv = QProcess::systemEnvironment();
  //
  //  Why is the m_strProgramInstallDir empty when running on the phone?
  //

  //listEnv << QString("TESSDATA_PREFIX=") + m_strProgramInstallDir + QString("/tesseract/");
  listEnv << QString("TESSDATA_PREFIX=") + QString("/opt/phototranslator-alpha/tesseract/");
  m_process->setEnvironment(listEnv);

  // Create arguments for tesseract
  QStringList arguments;

  arguments << a_image;
  //arguments << "/home/user/MyDocs/.documents/phototest.tif";
  arguments << OCR_Tesseract::tesseractTextFilePathNoExtension;

  QString strLang = m_mapLanguage.value(a_lang, "");
  if(!strLang.isEmpty())
  {
    arguments << "-l";
    arguments << strLang;
  }


  /*QFile file( OCR_Tesseract::tesseractTextFilePath );
  if( !file.open( QIODevice::ReadWrite ) )
      {
       emit error(tr("Couldn't create a text.txt in /home/user/MyDocs/tmp"));
      }
  else
      {
      file.close();
      emit error(tr("File created and closed"));
      }*/

  /*QProcess chmodProcess;
  QStringList chmodArguments;
  chmodArguments << "777";
  chmodArguments << OCR_Tesseract::tesseractTextFilePath;
  chmodProcess.start( "/bin/chmod", chmodArguments);

  if( !chmodProcess.waitForStarted() )
     emit error(tr("chmod failed"));*/

  /*QProcess exportTesseractTrainedData;
  exportTesseractTrainedData.setStandardOutputFile( "/opt/photonslator/exportStandard.txt" );
  exportTesseractTrainedData.setStandardErrorFile( "/opt/photonslator/exportError.txt" );
  exportTesseractTrainedData.start( "export", QStringList() << "TESSDATA_PREFIX" << "=/usr/local/share/tessdata/" );*/


  //emit error( m_strProgramInstallDir + QString("/tesseract/tesseract") + "!!!!" );
  m_process->setStandardOutputFile( "/opt/phototranslator-alpha/tesseractStandardOut.txt" );
  m_process->setStandardErrorFile( "/opt/phototranslator-alpha/tesseractErrorOut.txt" );

  // Start process
  //m_process->start(m_strProgramInstallDir + QString("/tesseract/tesseract"), arguments);
  m_process->start( QString("/opt/phototranslator-alpha/tesseract/tesseract"), arguments);

}

//-----------------------------------------------------------------------------
bool OCR_Tesseract::cancel()
{
  if(m_process)
  {
    qDebug() << "OCR_Tesseract::cancel(): running";

    m_cancelled = true;

    m_process->close();
    m_process->deleteLater();
    m_process = 0;

    return true;
  }

  qDebug() << "OCR_Tesseract::cancel(): not running";

  return false;
}

//-----------------------------------------------------------------------------
void OCR_Tesseract::processDone(int a_exitCode)
{
  if(m_cancelled)
  {
    qDebug() << "OCR_Tesseract::processDone(" << a_exitCode << "): cancelled -> skip";
    return;
  }

  qDebug() << "OCR_Tesseract::processDone(" << a_exitCode << ")";

  // Delete process
  if(m_process)
    m_process->deleteLater();
  m_process = NULL;

  QString strText;

  // Open file
  QFile file( OCR_Tesseract::tesseractTextFilePath );
  if(file.open(QIODevice::ReadWrite))
  {
    if(QTextCodec* codec = QTextCodec::codecForName("UTF-8"))
    {
      strText = codec->toUnicode(file.readAll());
      //emit error( strText );
    }

    file.close();
    bool bRemoved = file.remove();
    if(!bRemoved)
    {
        qDebug() << "OCR_Tesseract::processDone(" << a_exitCode << "): Unable to remove the text file!";
    }
  }
  else
  {
    qDebug() << "OCR_Tesseract::processDone(" << a_exitCode << "): Unable to open the text file (" << file.error() << ") !";
    emit error(tr("Unable to open the photo text. Try changing the photo selection or restarting PhotoTranslator."));
  }

  if(strText.simplified().isEmpty())
    emit error(tr("No text found from the photo selection. Try changing the photo selection."));
  else
    emit done(strText);
}

//-----------------------------------------------------------------------------
void OCR_Tesseract::processError(QProcess::ProcessError a_error)
{
  if(m_cancelled)
  {
    qDebug() << "OCR_Tesseract::processError(" << a_error << "): cancelled -> skip";
    return;
  }

  qDebug() << "OCR_Tesseract::processError(" << a_error << ")";

  // Delete process
  if(m_process)
    m_process->deleteLater();
  m_process = NULL;

  m_cancelled = true;
  switch(a_error)
  {
    case QProcess::FailedToStart:
      emit error(tr("Can't start tesseract, tesserract file missing or not enought permission rights to start it."));
      break;
    case QProcess::Timedout:
    case QProcess::Crashed:
      emit error(tr("Photo text recognition failed. Try changing the photo selection."));
      break;
    default:
      emit error(tr("Photo text recognition failed. Try restarting PhotoTranslator."));
      break;
  }
}

//-----------------------------------------------------------------------------
