//-----------------------------------------------------------------------------
#include "Utils.h"
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
QPolygonF Utils::makeBoundRect(const QPointF& a_p1, const QPointF& a_p2)
{
  qreal rTop    = a_p1.y() < a_p2.y() ? a_p1.y() : a_p2.y();
  qreal rBottom = a_p1.y() > a_p2.y() ? a_p1.y() : a_p2.y();
  qreal rLeft   = a_p1.x() < a_p2.x() ? a_p1.x() : a_p2.x();
  qreal rRight  = a_p1.x() > a_p2.x() ? a_p1.x() : a_p2.x();

  QPolygonF polygon;
  polygon << QPointF(rLeft, rTop);
  polygon << QPointF(rRight, rTop);
  polygon << QPointF(rRight, rBottom);
  polygon << QPointF(rLeft, rBottom);

  return polygon;
}

//-----------------------------------------------------------------------------
QLineF Utils::makeLineShortenedFromEnds(const QPointF& a_p1, const QPointF& a_p2, qreal a_short)
{
  QPointF unit = a_p2 - a_p1;
  unit /= QLineF(QPointF(0.0, 0.0), unit).length();
  unit *= a_short;
  return QLineF(a_p1+unit, a_p2-unit);
}

//-----------------------------------------------------------------------------
QRect Utils::toAbsoluteFromRelative(const QSize& a_size, const QRectF& a_relative)
{
  qreal w = qreal(a_size.width());
  qreal h = qreal(a_size.height());
  return QRect( QPoint(int(w * a_relative.left()), int(h * a_relative.top())),
                QPoint(int(w * a_relative.right()), int(h * a_relative.bottom())) );
}

//-----------------------------------------------------------------------------
QPointF Utils::toRelativeFromAbsolute(const QSize& a_size, const QPoint& a_absolute)
{
  qreal x = a_size.width() > 0 ? qreal(a_absolute.x()) / qreal(a_size.width()) : 0.0;
  qreal y = a_size.height() > 0 ? qreal(a_absolute.y()) / qreal(a_size.height()) : 0.0;
  return QPointF(x, y);
}

//-----------------------------------------------------------------------------
