/*
 * This file is part of phonelink
 *
 * Copyright (C) 2008 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
 
#ifndef PHONELINK_H
#define PHONELINK_H

/* D-BUS service definitions */
#define APPLICATION_DBUS_SERVICE 			"phonelink"
#define PHONELINK_DBUS_NAME 				"com.nokia.phonelink"
#define PHONELINK_DBUS_PATH 				"/com/nokia/phonelink"
#define PHONELINK_DBUS_INTERFACE 			"com.nokia.phonelink"
#define PHONELINK_DBUS_INCOMING_CALL_SIGNAL 	"incomingCall"
#define PHONELINK_DBUS_INCOMING_SMS_SIGNAL	"incomingSms"

#define GCONF_TRANSFORM_PLUS_KEY 		"/apps/phonelink/TransformPlusIntoDoubleZero"
#define GCONF_IGNORE_CONTACTINFOS_KEY	"/apps/phonelink/IgnoreContactInfosWhenNumber"
#define GCONF_SMS_DELIVERY_REPORT_KEY	"/apps/phonelink/SMSDeliveryReport"
#define GCONF_NOTIFY_CALL_KEY 			"/apps/phonelink/NotifyMeForIncomingCall"
#define GCONF_NOTIFY_SMS_KEY 			"/apps/phonelink/NotifyMeForSMSReception"
#define GCONF_SHOW_DIALPAD_KEY 		"/apps/phonelink/ShowDialPad"
#define GCONF_FULL_SCREEN_KEY 		"/apps/phonelink/FullScreen"

#define DIALPAD_DATA_KEY				"phonelink.dialpad"

#endif //PHONELINK_H
