#include "HiScores.h"
#include <QCryptographicHash>
#include <QDebug>

HiScores::HiScores(QObject *parent) :
    QObject(parent)
{
    m_networkManager = new QNetworkAccessManager(this);
    connect(m_networkManager, SIGNAL(finished(QNetworkReply*)),this, SLOT(replyFinished(QNetworkReply*)));

}

HiScores::~HiScores()
{
    delete m_networkManager;
}

void HiScores::createAccount(const QString &gamerName, const QString &password)
{
    qDebug() << "Create Account";
    QCryptographicHash hash(QCryptographicHash::Sha1);

    QUrl url("http://www.piggz.co.uk/spaceinvadersadmin.php");
    url.addQueryItem("action", "createaccount");
    url.addQueryItem("gamername", gamerName);
    url.addQueryItem("password", password);

    hash.addData(gamerName.toAscii());
    hash.addData(password.toAscii());
    hash.addData("pleasedonthackmyhiscoresystembecuaseitsjustnotcool");
    url.addQueryItem("hash", hash.result().toHex());

    QNetworkRequest request(url);
    m_networkManager->get(request);

}

void HiScores::sendHiScore(const QString &gamerName, const QString &password, const QString &level, const QString &score, const QString &scoredate)
{
    qDebug() << "Send HiScore";

    QCryptographicHash hash(QCryptographicHash::Sha1);
    QCryptographicHash passwdHash(QCryptographicHash::Sha1);

    QUrl url("http://www.piggz.co.uk/spaceinvadersadmin.php");
    url.addQueryItem("action", "uploadscore");
    url.addQueryItem("gamername", gamerName);
    url.addQueryItem("level", level);
    url.addQueryItem("score", score);
    url.addQueryItem("scoredate", scoredate);

    passwdHash.addData(password.toAscii() + "itsnotbigorclevertobreakthissystem");

    qDebug() << passwdHash.result().toHex();

    hash.addData(gamerName.toAscii());
    hash.addData(passwdHash.result().toHex());
    hash.addData(level.toAscii());
    hash.addData(score.toAscii());
    hash.addData(scoredate.toAscii());
    hash.addData("pleasedonthackmyhiscoresystembecuaseitsjustnotcool");
    url.addQueryItem("hash", hash.result().toHex());

    qDebug() << url;
    QNetworkRequest request(url);
    m_networkManager->get(request);
}

void HiScores::replyFinished(QNetworkReply *reply)
{
    m_lastMessage = reply->readAll();
    emit(messageReceived());
}

QString HiScores::lastMessage()
{
    qDebug() << m_lastMessage;
    return m_lastMessage;
}
