import QtQuick 1.0
import "sizer.js" as Sizer;

Rectangle {
    id: settingspanel
    height: board.height - 30
    width:  board.width/1.5
    y: 15
    state: "HIDDEN"
    border.color: "#00ff00"
    border.width: 5
    color:  "black"

    states: [
        State {
            name: "HIDDEN"
            PropertyChanges { target: settingspanel; x: board.width + 2}
        },
        State {
            name: "VISIBLE"
            PropertyChanges { target: settingspanel; x: board.width - width}
        }
    ]

    transitions: Transition {
        NumberAnimation { properties: "x"; easing.type: Easing.InOutQuad }
    }

    //Dummy mouse area to stop events being passed through
    MouseArea {
        anchors.fill: parent
    }
    //Flash Setting
    Rectangle {
        id: flashoption
        height: 40
        width: 40
        x: 20

        anchors.top: parent.top;
        anchors.topMargin: 20;

        border.color: "#00ff00"
        border.width: 5
        state: "FALSE"

        states: [
            State {
                name: "TRUE"
                PropertyChanges { target: flashoption; color: "#00ff00"}
            },
            State {
                name: "FALSE"
                PropertyChanges { target: flashoption; color: "#000000"}
            }
        ]

        MouseArea {
            anchors.fill: parent
            onClicked: {
                if (flashoption.state == "FALSE") {
                    flashoption.state = "TRUE";
                    flashOnFire = "TRUE";
                } else {
                    flashoption.state = "FALSE";
                    flashOnFire = "FALSE";
                }
            }
        }
    }

    Text {
        id: flashoptiontext
        text: "Flash on fire"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: flashoption.right
        anchors.leftMargin: 20
        anchors.top: flashoption.top
    }

    //Acceleromter Setting
    Rectangle {
        id: accelerometeroption
        height: 40
        width: 40
        x: 20

        anchors.top: flashoption.bottom;
        anchors.topMargin: 20;

        border.color: "#00ff00"
        border.width: 5
        state: "FALSE"

        states: [
            State {
                name: "TRUE"
                PropertyChanges { target: accelerometeroption; color: "#00ff00"}
            },
            State {
                name: "FALSE"
                PropertyChanges { target: accelerometeroption; color: "#000000"}
            }
        ]

        MouseArea {
            anchors.fill: parent
            onClicked: {
                if (accelerometeroption.state == "FALSE") {
                    accelerometeroption.state = "TRUE";
                    useAccelerometer = "TRUE";
                } else {
                    accelerometeroption.state = "FALSE";
                    useAccelerometer = "FALSE";
                }
            }
        }

    }
    Text {
        id: accelerometeroptiontext
        text: "Use Accelerometer"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: accelerometeroption.right
        anchors.leftMargin: 20
        anchors.top: accelerometeroption.top
    }

    //SFX Setting
    Rectangle {
        id: sfxoption
        height: 40
        width: 40
        x: 20

        anchors.top: accelerometeroption.bottom;
        anchors.topMargin: 20;

        border.color: "#00ff00"
        border.width: 5
        state: "FALSE"

        states: [
            State {
                name: "TRUE"
                PropertyChanges { target: sfxoption; color: "#00ff00"}
            },
            State {
                name: "FALSE"
                PropertyChanges { target: sfxoption; color: "#000000"}
            }
        ]

        MouseArea {
            anchors.fill: parent
            onClicked: {
                if (sfxoption.state == "FALSE") {
                    sfxoption.state = "TRUE";
                    sFX = "TRUE";
                } else {
                    sfxoption.state = "FALSE";
                    sFX = "FALSE";
                }
            }
        }

    }
    Text {
        id: sfxoptiontext
        text: "Sound Effects"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: sfxoption.right
        anchors.leftMargin: 20
        anchors.top: sfxoption.top
    }

    //Gamer Name
    Rectangle {
        id:gamernameborder
        height: Sizer.largeFontSize() + 8
        width: 160
        x: 20
        color: "#000000"
        border.color: "#00ff00"
        border.width: 4
        anchors.top: sfxoption.bottom;
        anchors.topMargin: 20;

        TextInput {
            id: gamernameoption
            anchors.fill: parent
            font.pixelSize: Sizer.largeFontSize()
            color: "#00ff00"
        }
    }

    Text {
        id: gamernametext
        text: "Gamer Name"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: gamernameborder.right
        anchors.leftMargin: 20
        anchors.top: gamernameborder.top
    }

    //Password
    Rectangle {
        id:passwordborder
        height: Sizer.largeFontSize() + 8
        width: 160
        x: 20
        color: "#000000"
        border.color: "#00ff00"
        border.width: 4
        anchors.top: gamernameborder.bottom;
        anchors.topMargin: 20;

        TextInput {
            id: passwordoption
            anchors.fill: parent
            font.pixelSize: Sizer.largeFontSize()
            color: "#00ff00"
        }
    }

    Text {
        id: passwordtext
        text: "Password"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: passwordborder.right
        anchors.leftMargin: 20
        anchors.top: passwordborder.top
    }

    Rectangle {
        id: createaccount
        height: Sizer.largeFontSize() + 10
        width: createaccounttext.width + 10
        color: "#00ff00"
        border.width: 1
        anchors.top: passwordborder.bottom;
        anchors.topMargin: 10;
        anchors.horizontalCenter: parent.horizontalCenter

        Text {
            id: createaccounttext
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            text: "Create Account"
            font.pixelSize: Sizer.largeFontSize()
            color: "#000000"
        }

        MouseArea  {
            anchors.fill: parent
            onClicked: {
                settingspanel.state = "HIDDEN";

                gamerName = gamernameoption.text;
                password = passwordoption.text;

                if (gamerName == "") {
                    board.displayMessage("Enter name");
                    return;
                }
                if (password == "") {
                    board.displayMessage("Enter password");
                    return;
                }
                board.displayMessage("Please Wait...");
                messagetimer.start();

                HiScores.createAccount(gamerName, password);
            }
        }
    }


    function startupFunction() {
        accelerometeroption.state = useAccelerometer;
        flashoption.state = flashOnFire;
        sfxoption.state = sFX;
        gamernameoption.text = gamerName;
        passwordoption.text = password;
    }

    Component.onCompleted: startupFunction();

}
