#ifndef BUNKER_H
#define BUNKER_H

#include <QDeclarativeItem>

const int bunkerWidth = 15;
const int bunkerHeight = 15;

const QString bunkerPattern = \
"     xxxxx     "\
"    xxxxxxx    "\
"   xxxxxxxxx   "\
"  xxxxxxxxxxx  "\
" xxxxxxxxxxxxx "\
"xxxxxxxxxxxxxxx"\
"xxxxxxxxxxxxxxx"\
"xxxxxxxxxxxxxxx"\
"xxxxxxxxxxxxxxx"\
"xxxxxxxxxxxxxxx"\
"xxxxxxxxxxxxxxx"\
"xxxxx     xxxxx"\
"xxxx       xxxx"\
"xxxx       xxxx"\
"xxxx       xxxx";


class Bunker : public QDeclarativeItem
{
    Q_OBJECT
public:
    explicit Bunker(QDeclarativeItem *parent = 0);

    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *options, QWidget * = 0);

signals:

public slots:
    void build();
    void demolish();
    bool checkCollision(int object_x, int object_y, int object_w, int object_h);
    bool checkCollisionRev(int object_x, int object_y, int object_w, int object_h);

private:
    void damageBunkerBomb(int);
    void damageBunkerLaser(int);
    void damageBunkerReal(int);

    QString m_bunkerMap;
};

#endif // BUNKER_H
