import QtQuick 1.0
import QtMobility.sensors 1.1

import "logic.js" as Logic
import "bunker.js" as Bunker1;
import "bunker.js" as Bunker2;
import "bunker.js" as Bunker3;
import "bunker.js" as Bunker4;
import "storage.js" as Settings;

Rectangle {
    id: board
    width: 800
    height: 480
    color: "#000000"

    ColorAnimation on color {id:flashanim; from: "#999999"; to: "black"; duration: 200 }

    MouseArea {
           id: themousearea
           x: 0
           y: 30
           width: 800
           height: 449
           drag.minimumY: -1000
           drag.minimumX: -1000
           drag.maximumY: 1000
           drag.maximumX: 1000
           anchors.rightMargin: 0
           anchors.bottomMargin: 1
           anchors.leftMargin: 0
           anchors.topMargin: 30
           anchors.fill: board
           onPressed: {
               if ((Logic.state == "stopped" || Logic.state == "waitingforlevelstart") && !deadtimer.running) {
                    Logic.startGame();
               } else {
                    Logic.fire();
               }
           }
       }

    Text {
        id: scoretext
        text: "Score: 0"
        color: "#ffffff"
        x: 5
        y: 5
    }

    Text {
        id: leveltext
        text: "Level: 0"
        color: "#ffffff"
        y: 5
        anchors.horizontalCenter: board.horizontalCenter
    }

    Text {
        id: starttext
        text: "Tap screen to start"
        color: "#ffffff"
        anchors.horizontalCenter: board.horizontalCenter
        anchors.verticalCenter: board.verticalCenter
    }


    Text {
        id: gameover
        text: "GAME OVER"
        font.pointSize: 30
        color: "#00ff00"
        anchors.horizontalCenter: board.horizontalCenter
        anchors.bottom: starttext.top
        visible: false
    }

    Image {
        id: ship
        x: 355
        y: 410
        width: 50
        height: 30
        rotation: 0
        source: "pics/ship.png"
        }

    Timer {
             id: heartbeat;
             interval: 50
             running: false;
             repeat: true;
             onTriggered: Logic.mainEvent();
         }

    Timer {
        id: alienanimation
        interval:  600
        running: false
        repeat: true
        onTriggered: Logic.moveAliens()
    }

    Timer  {
        id: deadtimer
        interval: 5000
        running: false
        repeat: false
        onTriggered: {
            gameover.visible = false;
            starttext.visible = true;
        }
    }

    Image {
        id: closebutton

        source: "pics/close.png"
        width: 35
        height: 35
        anchors.right: parent.right
        anchors.rightMargin: 0
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: false

        MouseArea {
               id: closearea
               anchors.fill: closebutton
               onPressed: Qt.quit()
               }
           }


    Image {
        id: settingsbutton
        source: "pics/settings.png"
        anchors.right: settingspanel.left
        anchors.bottom: board.verticalCenter
        anchors.bottomMargin: 10
        width: 60
        height: 60


        MouseArea {
            id: settingsarea
            anchors.fill: settingsbutton
            onClicked: {
                if (settingspanel.state == "HIDDEN") {
                    settingspanel.state = "VISIBLE";

                } else {
                    settingspanel.state = "HIDDEN";
                }
            }
        }
    }


    Image {
        id: hiscorebutton
        source: "pics/hiscore.png"
        anchors.right: hiscorepanel.left
        anchors.top: board.verticalCenter
        anchors.topMargin: 10
        width: 60
        height: 60


        MouseArea {
            id: hiscorearea
            anchors.fill: hiscorebutton
            onClicked: {
                if (hiscorepanel.state == "HIDDEN") {
                    hiscorepanel.state = "VISIBLE";

                } else {
                    hiscorepanel.state = "HIDDEN";
                }
            }
        }
    }


    Rectangle {
        width: 800
        height:  1
        x: 0
        y: 450
        color: "#00ff00"

    }

    Rectangle {
        width: 800
        height:  1
        x: 0
        anchors.top: closebutton.bottom
        color: "#00ff00"
    }

    Accelerometer  {
        id: accelerometer
        Component.onCompleted: start()
        onReadingChanged: {
            var r = reading
            Logic.scheduleDirection((r.x) * -5);

        }
    }

    Settingswindow {
        id:settingspanel;
        z: 10
    }

    Hiscorewindow {
        id:hiscorepanel;
        z: 9
    }

    function startupFunction() {
        Settings.initialize();
        Settings.loadSettings();
    }

    Component.onCompleted: startupFunction();

    focus: true
    Keys.onTabPressed: Logic.endGame();

    Keys.onSpacePressed: Logic.fire();
    Keys.onLeftPressed: Logic.scheduleDirection(-10);
    Keys.onRightPressed: Logic.scheduleDirection(10);
    Keys.onEscapePressed: Qt.quit();



}


