#include "LatitudeSettings.h"
#include <QSpinBox>
#include <QPushButton>
#include <QBoxLayout>
#include <QComboBox>
#include <QLabel>

LatitudeSettings::LatitudeSettings(QWidget *parent) :
    QDialog(parent)
{
    m_hlayout1 = new QHBoxLayout();
    m_hlayout2 = new QHBoxLayout();
    m_hlayout3 = new QHBoxLayout();
    m_vlayout = new QVBoxLayout();

    m_refresh = new QSpinBox(this);
    m_refresh->setRange(5,60);

    m_method = new QComboBox(this);
    m_method->addItem(tr("Satelite"), QGeoPositionInfoSource::SatellitePositioningMethods);
    m_method->addItem(tr("Non Satelite"), QGeoPositionInfoSource::NonSatellitePositioningMethods);
    m_method->addItem(tr("All"), QGeoPositionInfoSource::AllPositioningMethods);


    m_okButton = new QPushButton(tr("Ok"), this);
    connect(m_okButton, SIGNAL(clicked()), this, SLOT(accept()));

    m_hlayout1->addWidget(new QLabel("Refresh Rate"));
    m_hlayout1->addWidget(m_refresh);

    m_hlayout2->addWidget(new QLabel("Positioning Method"));
    m_hlayout2->addWidget(m_method);

    m_hlayout3->addStretch();
    m_hlayout3->addWidget(m_okButton);

    m_vlayout->addLayout(m_hlayout1);
    m_vlayout->addLayout(m_hlayout2);
    m_vlayout->addLayout(m_hlayout3);

    setLayout(m_vlayout);
}

LatitudeSettings::~LatitudeSettings()
{

}

void LatitudeSettings::slotAuthorize()
{
    emit(authorize());
}

int LatitudeSettings::updateInterval()
{
    return m_refresh->value();
}

QGeoPositionInfoSource::PositioningMethod LatitudeSettings::positioningMethod()
{
    return (QGeoPositionInfoSource::PositioningMethod)(m_method->itemData(m_method->currentIndex()).toInt());
}

void LatitudeSettings::setUpdateIterval(int minutes)
{
    m_refresh->setValue(minutes);
}

void LatitudeSettings::setPositioningMethod(QGeoPositionInfoSource::PositioningMethod method)
{
    if (method == QGeoPositionInfoSource::SatellitePositioningMethods) {
        m_method->setCurrentIndex(0);
    } else if (method == QGeoPositionInfoSource::NonSatellitePositioningMethods) {
        m_method->setCurrentIndex(1);
    } else {
        m_method->setCurrentIndex(2);
    }
}
