#include "LatitudeSettings.h"
#include <QSpinBox>
#include <QPushButton>
#include <QBoxLayout>

LatitudeSettings::LatitudeSettings(QWidget *parent) :
    QDialog(parent)
{
    m_hlayout1 = new QHBoxLayout();
    m_hlayout2 = new QHBoxLayout();
    m_vlayout = new QVBoxLayout();

    //m_authButton = new QPushButton(tr("Authorize"), this);
    //connect(m_authButton, SIGNAL(clicked()), this, SLOT(slotAuthorize()));

    m_refresh = new QSpinBox(this);
    m_refresh->setRange(5,60);

    m_okButton = new QPushButton(tr("Ok"), this);
    connect(m_okButton, SIGNAL(clicked()), this, SLOT(accept()));

    //m_hlayout1->addWidget(m_authButton);
    m_hlayout1->addWidget(m_refresh);

    m_hlayout2->addStretch();
    m_hlayout2->addWidget(m_okButton);

    m_vlayout->addLayout(m_hlayout1);
    m_vlayout->addLayout(m_hlayout2);

    setLayout(m_vlayout);
}

LatitudeSettings::~LatitudeSettings()
{

}

void LatitudeSettings::slotAuthorize()
{
    emit(authorize());
}

int LatitudeSettings::updateInterval()
{
    return m_refresh->value();
}
