import QtQuick 1.0

Item {
    anchors.fill: parent

    signal playGame(string levelPack, string background, int levels)

    Rectangle {
        anchors.fill: parent;

        color: "#cce6f3"

        Image {
            id:header
            source: "pics/pickafarm.svg"
            width:250
            height:30
            smooth:true
            fillMode: Image.Stretch
            anchors.top: parent.top
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.margins: 10
        }

        Component {
            id: levelDelegate

            Rectangle {
                width:parent.width
                height: text1.height + text2.height + text3.height + 10
                radius: 10
                clip: true

                Image {
                    id:levelicon
                    width:64
                    height:64
                    source: "levels/" + levelid + "/icon.png"
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 10
                }

                Text {
                    id: text1
                    y:5
                    anchors.right: parent.right
                    anchors.rightMargin: 10
                    anchors.left: levelicon.right
                    anchors.leftMargin: 10
                    text: name
                    font.bold: true
                    font.pixelSize: 20
                }
                Text {
                    id: text2
                    anchors.right: parent.right
                    anchors.rightMargin: 10
                    anchors.left: levelicon.right
                    anchors.leftMargin: 10
                    anchors.top: text1.bottom
                    text: description
                    font.pixelSize: 20
                    wrapMode: Text.WordWrap
                }
                Text {
                    id:text3
                    anchors.right: parent.right
                    anchors.rightMargin: 10
                    anchors.left: levelicon.right
                    anchors.leftMargin: 10
                    anchors.top: text2.bottom
                    text: "Number of levels: " + numlevels
                    font.pixelSize: 20

                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        playGame(levelid, backgroundimage, numlevels);
                    }
                }

            }


        }

        ListView {
            anchors.top: header.bottom
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: parent.bottom

            anchors.margins: 10

            clip: true
            model: LevelPackModel
            delegate: levelDelegate
        }
    }
}
