#ifndef MAPWIDGET_H
#define MAPWIDGET_H

#include <QWidget>
#include <QtLocation/QGeoCoordinate>
#include <QtLocation/QGeoMapObject>
#include <QPushButton>
#include <QtLocation/QGraphicsGeoMap>

class TrailInterface;
class QGraphicsView;
class QGraphicsScene;
class QBoxLayout;
class KineticMapItem;

class MapWidget : public QWidget
{
    Q_OBJECT
public:
    explicit MapWidget(TrailInterface*, QWidget *parent = 0);
    ~MapWidget();

signals:

public slots:
    void addMapObject(QtMobility::QGeoMapObject*);
    void removeMapObject(QtMobility::QGeoMapObject*);
    void clearMapObjects();
    void setCenter(QtMobility::QGeoCoordinate);
    void setConnectivityMode(QtMobility::QGraphicsGeoMap::ConnectivityMode);

private slots:
    void zoomIn();
    void zoomOut();

protected:
    virtual void resizeEvent(QResizeEvent *);

private:
    TrailInterface *m_interface;
    QGraphicsView *m_view;
    QGraphicsScene *m_scene;
    KineticMapItem *m_map;

    QBoxLayout *m_layout;
    QBoxLayout *m_btnLayout;

    QPushButton *m_zoomIn;
    QPushButton *m_zoomOut;

};

#endif // MAPWIDGET_H
