#include "MapWidget.h"
#include "trailinterface.h"
#include <QGraphicsScene>
#include <QGraphicsView>
#include <QGraphicsLinearLayout>
#include <QGraphicsWidget>
#include <QBoxLayout>
#include <QtLocation/QGeoBoundingBox>
#include <QtLocation/QGeoMapData>
#include "KineticMapItem.h"

MapWidget::MapWidget(TrailInterface *interface, QWidget *parent) :
    QWidget(parent)
{
    m_interface = interface;

    m_layout = new QBoxLayout(QBoxLayout::TopToBottom, this);

    m_scene = new QGraphicsScene(this);
    m_scene->setSceneRect(0,0,800,800);

    m_view = new QGraphicsView(m_scene, this);
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_view->setVisible(true);
    m_view->setInteractive(true);

    m_map = new KineticMapItem(interface->mappingManager());
    m_map->setCenter(QtMobility::QGeoCoordinate(-27.0, 152.0));
    m_map->setZoomLevel(13);
    m_map->setMapType(QtMobility::QGraphicsGeoMap::TerrainMap);

    QGraphicsLinearLayout *layout = new QGraphicsLinearLayout;
    layout->addItem(m_map);

    QGraphicsWidget *form = new QGraphicsWidget;
    form->setLayout(layout);
    m_scene->addItem(form);

    //Buttons
    m_zoomIn = new QPushButton(QIcon(":/images/list-add.png"), "", this);
    m_zoomOut = new QPushButton(QIcon(":/images/list-remove.png"), "", this);

    m_btnLayout = new QBoxLayout(QBoxLayout::LeftToRight, this);
    m_btnLayout->addStretch();
    m_btnLayout->addWidget(m_zoomOut);
    m_btnLayout->addWidget(m_zoomIn);

    connect(m_zoomOut, SIGNAL(clicked()), this, SLOT(zoomOut()));
    connect(m_zoomIn, SIGNAL(clicked()), this, SLOT(zoomIn()));

    m_layout->addWidget(m_view);
    m_layout->addLayout(m_btnLayout);
    setLayout(m_layout);
}

MapWidget::~MapWidget() {
}

void MapWidget::addMapObject(QtMobility::QGeoMapObject *obj)
{
    m_map->addMapObject(obj);
}

void MapWidget::removeMapObject(QtMobility::QGeoMapObject *obj)
{
    m_map->removeMapObject(obj);
}

void MapWidget::clearMapObjects()
{
    m_map->clearMapObjects();
}

void MapWidget::setCenter(QtMobility::QGeoCoordinate pos)
{
    m_map->setCenter(pos);
}

void MapWidget::zoomIn()
{
    m_map->setZoomLevel(m_map->zoomLevel() + 1);
}

void MapWidget::zoomOut()
{
    m_map->setZoomLevel(m_map->zoomLevel() - 1);
}

void MapWidget::resizeEvent(QResizeEvent *event)
{
    //Re-layout the buttons
    if (event->size().width() > event->size().height()) {
        //Landscape
        m_btnLayout->setDirection(QBoxLayout::TopToBottom);
        m_layout->setDirection(QBoxLayout::LeftToRight);
    } else {
        //Portrait
        m_btnLayout->setDirection(QBoxLayout::LeftToRight);
        m_layout->setDirection(QBoxLayout::TopToBottom);
    }

    //Resize the map
    m_scene->setSceneRect(QRectF(QPointF(0,0), event->size()));
    m_map->setGeometry(m_scene->sceneRect());
}

void MapWidget::setConnectivityMode(QGraphicsGeoMap::ConnectivityMode cm)
{
    m_map->setConnectivityMode(cm);
}
