#ifndef TRAILTRIPVIEW_H
#define TRAILTRIPVIEW_H

#include <QWidget>
#include "trailtrip.h"

class QPushButton;
class QVBoxLayout;
class QLabel;

class TrailInterface;
class TrailGPXView;

class TrailTripView : public QWidget
{
Q_OBJECT
public:
    explicit TrailTripView(TrailInterface* interface, TrailGPXView *mapView, QWidget *parent = 0);
    void setTrip(const TrailTrip&);

private:
    TrailInterface* m_interface;

    QVBoxLayout *m_layout;

    QLabel *m_name;
    QLabel *m_description;
    QLabel *m_activity;
    QLabel *m_date;
    QLabel *m_length;
    QLabel *m_duration;

    QUrl m_gpxUrl;
    QUrl m_kmlUrl;

    long m_id;

    QPushButton *m_downloadGPX;
    QPushButton *m_downloadKML;
    QPushButton *m_viewMap;

    QList<QLabel*> m_pictures;
    TrailGPXView *m_mapView;

private slots:
    void slotViewMap();
    void slotGotMapData(const QDomDocument&);

signals:
    void navigateViewMap();

public slots:

};

#endif // TRAILTRIPVIEW_H
