#ifndef TRAILGPXRECORDER_H
#define TRAILGPXRECORDER_H

#include <QWidget>
#include "TrailTrackModel.h"
#include <QtLocation/QGeoPositionInfoSource>
#include <QtLocation/QGeoMapObject>
#include <QtLocation/QGeoMapCircleObject>
#include <QtLocation/QGeoMapPolylineObject>

class QLabel;
class QTableView;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class TrailInterface;
class MapWidget;
class QStackedWidget;
class QGraphicsView;
class QGraphicsScene;

using namespace QtMobility;

class TrailGPXRecorder : public QWidget
{
    Q_OBJECT
public:
    explicit TrailGPXRecorder(TrailInterface *, QWidget *parent = 0);
    ~TrailGPXRecorder();

private:
    QLabel *m_curPos;
    QLabel *m_curLongitude;
    QLabel *m_curLatitude;
    QTableView *m_gpxList;
    QPushButton *m_record;
    QPushButton *m_stop;
    QPushButton *m_save;
    QPushButton *m_switch;

    QGraphicsView *m_qgv;
    QGraphicsScene *m_scene;
    MapWidget *m_mapWidget;

    QVBoxLayout *m_layout;
    QHBoxLayout *m_btnLayout;
    QStackedWidget *m_mapStack;

    TrailInterface *m_interface;
    QGeoPositionInfoSource *m_location;

    TrailTrackModel *m_model;

    QGeoMapCircleObject *m_currentCircle;
    QList<QGeoCoordinate> m_path;
    QGeoMapPolylineObject *m_poly;

signals:

protected:
    virtual void resizeEvent(QResizeEvent *);

public slots:

private slots:
    void slotRecord();
    void slotStop();
    void slotSave();
    void slotSwitchView();
    void positionUpdated(const QGeoPositionInfo&);

    void clearMapObjects();
    void addMapObject(QtMobility::QGeoMapObject *obj, bool fit);

};

#endif // TRAILGPXRECORDER_H
