#ifndef TRAILTRIP_H
#define TRAILTRIP_H
#include <QString>
#include <QDate>
#include <QtXml/QDomElement>
#include <QUrl>

class TrailPicture
{
public:
    TrailPicture(const QDomElement&);
    QString thumbnail() const;

private:
    int m_id;
    QString m_thumbnail;
};

class TrailTrip
{
public:
    TrailTrip(const QDomElement&);
    QString tripName() const {return m_name;}
    QString activity() const {return m_activity;}
    QString description() const {return m_description;}
    QString dateString() const {return m_date.toString();}
    QString lengthString() const {return QString("%1km").arg(m_length/1000);}
    QString durationString() const {return QString("%1hours").arg((m_duration/60)/60);}

    int pictureCount() const;
    QString pictureThumbnail(int) const;

    QUrl gpx() const {return m_gpx;}
    QUrl kml() const {return m_kml;}
    long id() const {return m_id;}

private:
    long m_id;
    QString m_name;
    int m_userId;
    QString m_userName;
    QString m_activity;
    QString m_description;
    QString m_tips;
    QDate m_date;
    QString m_location;
    QUrl m_gpx;
    QUrl m_kml;
    float m_length;
    float m_duration;

    QList<TrailPicture*> m_pictures;

};

#endif // TRAILTRIP_H
