#include "trailtripview.h"
#include <qlayout.h>
#include <QLabel>
#include <QPushButton>
#include "trailinterface.h"
#include "TrailGPXView.h"
#include <QDebug>
#include <QtXml/QDomDocument>
#include <QtXml/QDomNodeList>
#include <QtLocation/QGeoMapPolylineObject>

TrailTripView::TrailTripView(TrailInterface *interface, TrailGPXView *mapView, QWidget *parent) :
    QWidget(parent), m_mapView(mapView)
{
    m_interface = interface;
    m_layout = new QVBoxLayout(this);

    m_name = new QLabel(this);
    m_name->setWordWrap(true);
    m_name->setFocusPolicy(Qt::TabFocus);
    m_layout->addWidget(m_name);

    m_description = new QLabel(this);
    m_description->setWordWrap(true);
    m_description->setFocusPolicy(Qt::TabFocus);
    m_layout->addWidget(m_description);

    m_activity = new QLabel(this);
    m_activity->setWordWrap(true);
    m_activity->setFocusPolicy(Qt::TabFocus);
    m_layout->addWidget(m_activity);

    m_date = new QLabel(this);
    m_date->setWordWrap(true);
    m_date->setFocusPolicy(Qt::TabFocus);
    m_layout->addWidget(m_date);

    m_length = new QLabel(this);
    m_length->setWordWrap(true);
    m_length->setFocusPolicy(Qt::TabFocus);
    m_layout->addWidget(m_length);

    m_duration = new QLabel(this);
    m_duration->setWordWrap(true);
    m_duration->setFocusPolicy(Qt::TabFocus);
    m_layout->addWidget(m_duration);

    m_viewMap = new QPushButton("View", this);
    connect(m_viewMap, SIGNAL(clicked()), this, SLOT(slotViewMap()));

    m_layout->addWidget(m_viewMap);
    m_layout->addStretch();

    setLayout(m_layout);

    connect(m_interface, SIGNAL(trackLoaded(QDomDocument)), this, SLOT(slotGotMapData(QDomDocument)));
}

void TrailTripView::setTrip(const TrailTrip &trip)
{
    m_name->setText("<b>Name:</b> " + trip.tripName());
    m_description->setText("<b>Description:</b> " + trip.description());
    m_activity->setText("<b>Activity:</b> " + trip.activity());
    m_date->setText("<b>Date:</b> " + trip.dateString());
    m_length->setText("<b>Length:</b> " + trip.lengthString());
    m_duration->setText("<b>Duration:</b> " + trip.durationString());

    m_id = trip.id();
    m_gpxUrl = trip.gpx();
    m_kmlUrl = trip.kml();

    qDeleteAll(m_pictures);
    m_pictures.clear();

    delete m_layout->takeAt(m_layout->count() - 1); //Remove the stretch item

    int piccount = trip.pictureCount();
    for (int i = 0; i < piccount; ++i)
    {
        QLabel *pic = new QLabel(this);
        pic->setPixmap(m_interface->getImage(QUrl(trip.pictureThumbnail(i))));
        pic->setAlignment(Qt::AlignCenter);
        pic->setFocusPolicy(Qt::TabFocus);
        m_layout->addWidget(pic);
        m_pictures.append(pic);
    }

    m_layout->addStretch();
}

void TrailTripView::slotGotMapData(const QDomDocument &gpx)
{
    double lat, lon;

    QDomNodeList trkpts = gpx.elementsByTagName("trkpt");

    m_mapView->clearMapObjects();

    QList<QGeoCoordinate> path;

    for (int i = 0; i < trkpts.count(); ++i) {
        QDomElement pt = trkpts.at(i).toElement();

        lat = pt.attribute("lat").toDouble();
        lon = pt.attribute("lon").toDouble();

        path << QGeoCoordinate(lat, lon);
    }

    if (!path.isEmpty())
    {
        QGeoMapPolylineObject *obj = new QGeoMapPolylineObject();
        obj->setPath(path);
        obj->setPen(QPen(Qt::red));

        m_mapView->addMapObject(obj, true);
    }
}

void TrailTripView::slotViewMap()
{
    m_interface->getTripXML(m_id);
    emit(navigateViewMap());
}
