#ifndef TRAILMAINMENU_H
#define TRAILMAINMENU_H

#include <QWidget>

class QPushButton;
class QVBoxLayout;
class TrailInterface;

class TrailMainMenu : public QWidget
{
Q_OBJECT
public:
    explicit TrailMainMenu(TrailInterface*, QWidget *parent = 0);

private:
    QVBoxLayout *m_layout;
    QPushButton *m_createTrip;
    QPushButton *m_myTrips;
    QPushButton *m_recordTrip;
    QPushButton *m_search;

    TrailInterface* m_interface;

private slots:
    void slotMyTripsClicked();
    void slotRecordTripClicked();
    void slotCreateTripClicked();
    void slotSearchClicked();

signals:
    void gotMyTrips();
    void navigateRecordTrip();
    void navigateCreateTrip();
    void navigateSearch();

public slots:

};

#endif // TRAILMAINMENU_H
