#ifndef TRAILGPXRECORDER_H
#define TRAILGPXRECORDER_H

#include <QWidget>
#include "TrailTrackModel.h"
#include  <QtLocation/QGeoPositionInfoSource>

class QLabel;
class QTableView;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class TrailInterface;

using namespace QtMobility;

class TrailGPXRecorder : public QWidget
{
    Q_OBJECT
public:
    explicit TrailGPXRecorder(TrailInterface *, QWidget *parent = 0);
    ~TrailGPXRecorder();

private:
    QLabel *m_curPos;
    QLabel *m_curLongitude;
    QLabel *m_curLatitude;
    QTableView *m_gpxList;
    QPushButton *m_record;
    QPushButton *m_stop;
    QPushButton *m_save;

    QVBoxLayout *m_layout;
    QHBoxLayout *m_btnLayout;

    TrailInterface *m_interface;
    QGeoPositionInfoSource *m_location;

    TrailTrackModel *m_model;
    
signals:

protected:
    virtual void resizeEvent(QResizeEvent *);

public slots:

private slots:
    void slotRecord();
    void slotStop();
    void slotSave();
    void positionUpdated(const QGeoPositionInfo&);
};

#endif // TRAILGPXRECORDER_H
