#include "TripDelegate.h"
#include <QDebug>
#include <QPainter>

TripDelegate::TripDelegate(QObject *parent) : QItemDelegate(parent)
{

}

TripDelegate::~TripDelegate()
{

}

void TripDelegate::paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    QString title = index.data().toString();
    QString activity = index.data(Qt::UserRole + 1).toString();
    QString length = index.data(Qt::UserRole + 2).toString();

    QRect r = option.rect;

    QPalette p;

    QColor d = p.color(QPalette::Button);
    d.setHsv(d.hue(), d.saturation(), (d.value() + 50 > 255 ? d.value() - 50 : d.value() + 50));

    QLinearGradient g(r.topLeft(), r.bottomLeft());
    g.setColorAt(0, p.color(QPalette::Button));
    g.setColorAt(1, d);

    painter->setBackground(g);
    painter->fillRect(r, g);

    if (option.state & QStyle::State_Selected)
    {
        QPolygon triangle;

        triangle.clear();

        triangle << QPoint(r.right(), r.top());
        triangle << QPoint(r.right(), r.bottom());
        triangle << QPoint(r.right() - 30, r.top() + r.height() / 2);

        qDebug() << triangle;

        painter->save();
        painter->setBrush(p.color(QPalette::Highlight));
        painter->setPen(p.color(QPalette::Highlight));
        painter->drawPolygon(triangle);
        painter->restore();
    }

    QFont titleFont = painter->font();
    titleFont.setBold(true);
    titleFont.setItalic(false);

    QFont plainFont = painter->font();
    plainFont.setBold(false);
    plainFont.setItalic(false);

    QFont italicFont = option.font;
    italicFont.setBold(false);
    italicFont.setItalic(true);

    QFontMetrics titleMetrics(titleFont);
    QRect titleRect = titleMetrics.boundingRect(r.left() + 5, r.top() + 5, r.width() - 10, 5000, Qt::AlignLeft | Qt::TextWordWrap, title);

    QFontMetrics activityMetrics(plainFont);
    QRect activityRect = activityMetrics.boundingRect(r.left() + 5, r.top() + 5, r.width() - 10, 5000, Qt::AlignLeft | Qt::TextWordWrap, activity);

    QFontMetrics lengthMetrics(italicFont);
    QRect lengthRect = lengthMetrics.boundingRect(r.left() + 5, r.top() + 5, r.width() - 10, 5000, Qt::AlignLeft | Qt::TextWordWrap, length);

    activityRect.moveTop(titleRect.bottom() + 5);
    lengthRect.moveTop(activityRect.bottom() + 5);

    //Title
    painter->setFont( titleFont );
    painter->drawText(titleRect, Qt::AlignTop | Qt::AlignLeft | Qt::TextWordWrap, title);

    //Activity
    painter->setFont( plainFont );
    painter->drawText(activityRect, Qt::AlignLeft | Qt::TextWordWrap, activity);

    //Length
    painter->setFont( italicFont );
    painter->drawText(lengthRect, Qt::AlignLeft | Qt::TextWordWrap, length);



}

QSize TripDelegate::sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    QString title = index.data().toString();
    QString activity = index.data(Qt::UserRole + 1).toString();
    QString length = index.data(Qt::UserRole + 2).toString();

    QRect r = option.rect;

    QFont titleFont = option.font;
    titleFont.setBold(true);
    titleFont.setItalic(false);

    QFont plainFont = option.font;
    plainFont.setBold(false);
    plainFont.setItalic(false);

    QFont italicFont = option.font;
    italicFont.setBold(false);
    italicFont.setItalic(true);

    QFontMetrics titleMetrics(titleFont);
    QRect titleRect = titleMetrics.boundingRect(r.left() + 5, r.top() + 5, r.width() - 10, 5000, Qt::AlignLeft | Qt::TextWordWrap, title);

    QFontMetrics activityMetrics(plainFont);
    QRect activityRect = activityMetrics.boundingRect(r.left() + 5, r.top() + 5, r.width() - 10, 5000, Qt::AlignLeft | Qt::TextWordWrap, activity);

    QFontMetrics lengthMetrics(italicFont);
    QRect lengthRect = lengthMetrics.boundingRect(r.left() + 5, r.top() + 5, r.width() - 10, 5000, Qt::AlignLeft | Qt::TextWordWrap, length);

    activityRect.moveTop(titleRect.bottom() + 5);
    lengthRect.moveTop(activityRect.bottom() + 5);

    return QSize(option.rect.width(), lengthRect.bottom() + 5);
}

