#include "pggui.h"
#include<QTextCodec>
pggui::pggui(QWidget *parent)
    : QWidget(parent)
{
    gpgText = new QTextEdit;
    gpgRunButton = new QPushButton(tr("Run GPG"));
    gpgEncryptButton = new QPushButton(tr("Encryption"));
    gpgDecryptButton = new QPushButton(tr("Decryption"));
    gpgKeyManagmentButton = new QPushButton(tr("Key Managemnt"));
    strLine = new QString;


    QHBoxLayout *ButtonLayout1 = new QHBoxLayout;
    ButtonLayout1->addWidget(gpgEncryptButton);
    ButtonLayout1->addWidget(gpgDecryptButton);
    ButtonLayout1->addWidget(gpgKeyManagmentButton);
    ButtonLayout1->addWidget(gpgRunButton);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(gpgText);
    mainLayout->addLayout(ButtonLayout1);

    this->setLayout(mainLayout);
    setWindowTitle("Gnu PG GUI");



#ifdef Q_WS_MAEMO_5

    // enable the kinetic scroller on scrollArea
     QAbstractKineticScroller *scroller = gpgText->property("kineticScroller")
                                              .value<QAbstractKineticScroller *>();
     scroller->setEnabled(1);
     this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

     //Key Management Window start

     gpgCreateKeysButton = new QPushButton(tr("Create Keys"));
     gpgImportKeysButton = new QPushButton(tr("Import Keys"));
     gpgSetKeyButton = new QPushButton(tr("set Key"));

     gpgKeyManagmentButton->setEnabled(0);
     gpgEncryptButton->setEnabled(0);



     KeyManagmentWindow = new QMainWindow(this);

 #ifdef Q_WS_MAEMO_5
     KeyManagmentWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
 #endif

     QVBoxLayout *KeyManagmentWindowLayout = new QVBoxLayout;
     KeyManagmentWindowLayout->addWidget(gpgCreateKeysButton);
     KeyManagmentWindowLayout->addWidget(gpgImportKeysButton);
     KeyManagmentWindowLayout->addWidget(gpgSetKeyButton);


     QWidget *KeyManagemntLayout = new QWidget;
     KeyManagemntLayout->setLayout(KeyManagmentWindowLayout);
     KeyManagmentWindow->setCentralWidget(KeyManagemntLayout);


     //Key Management Window end


     //Password Enter Window start

//     passwordLine = new QLineEdit;
//     QPushButton *passwordOk = new QPushButton(tr("OK"));
//     passwordLine->setEchoMode(QLineEdit::Password);

//     gpgEnterKeyWindow = new QMainWindow(KeyManagmentWindow);

//#ifdef Q_WS_MAEMO_5
//    gpgEnterKeyWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
//#endif

//     QHBoxLayout *gpgEnterKeyWindowLayout = new QHBoxLayout;
//     gpgEnterKeyWindowLayout->addWidget(passwordLine);
//     gpgEnterKeyWindowLayout->addWidget(passwordOk);


//     QWidget *gpgEnterKeyWindowLayoutWidget = new QWidget;
//     gpgEnterKeyWindowLayoutWidget->setLayout(gpgEnterKeyWindowLayout);
//     gpgEnterKeyWindow->setCentralWidget(gpgEnterKeyWindowLayoutWidget);

     //Password Enter Window end

   dialog = new passwordDialog;

   gpg = new QProcess;

   connect(gpgRunButton,SIGNAL(clicked()),this,SLOT(gpgRun()));
   connect(gpg,SIGNAL(readyReadStandardOutput()),this,SLOT(slotStringReceived())); //Receive output
   connect(gpg,SIGNAL(readyReadStandardError()),this,SLOT(slotErrorStringReceived())); //Receive Errors
   connect(gpgEncryptButton,SIGNAL(clicked()),this,SLOT(gpgEncryption()));
   connect(gpgDecryptButton,SIGNAL(clicked()),this,SLOT(gpgDecryption()));
   connect(gpgKeyManagmentButton,SIGNAL(clicked()),KeyManagmentWindow,SLOT(show()));




   QTextCodec::setCodecForCStrings( QTextCodec::codecForName( "UTF-8" ) ); //general Text-Coding, needed for "Umlaute"
   QTextCodec::setCodecForLocale( QTextCodec::codecForName("UTF-8") );
   QTextCodec::setCodecForTr( QTextCodec::codecForName("UTF-8") );


}

void pggui::gpgRun()
{
    qDebug("Starting gpg --help");
    gpgText->clear();
    QString program = "gpg";
    QStringList arguments;

    arguments << "--help";

    gpg->start(program, arguments);



}

void pggui::slotStringReceived()
{

//Insert if loop here, in order to check the input and to know what to do with it
    *strLine = QString(gpg->readAllStandardOutput());


    //check if encoded message has been encoded in Base64
    if (strLine->contains("Content-Transfer-Encoding: base64")) {
        gpgDecode();
    } else {
        gpgText->append(*strLine);
    }


}

void pggui::gpgEncryption()
{


    //    QFile file("/home/user/MyDocs/.documents/encrypted");

    //    if (file.isOpen())
    //    {
    //        gpgText->append("File successfully opened");
    //    } else {
    //        file.open(QFile::ReadOnly);
    //        gpgText->append("manually opened file");
    //    }

    //    if (file.exists())
    //        gpgText->append("file exissts");
    //    if (file.isReadable())
    //        gpgText->append("file is readable");
    //    if (!file.exists())
    //        return;


    //    while (!file.atEnd()) {
    //             QByteArray line = file.readLine();
    //             gpgText->append(line);
    //         }


}

void pggui::gpgDecryption()
{

    gpgText->clear();


    qDebug() << "GPG Decryptionslot started...";
    qDebug() <<"Choose File to decrypt...";

    QString fileName;

    fileName = QFileDialog::getOpenFileName(this,tr("Find file"),"/home/user/.documents/",
                                            tr("Encrypted messages (*.gpg *.asc)"));

    qDebug() << "Filename: " << fileName;

    dialog->show();

    if (dialog->exec() == QDialog::Accepted) {
        QString password = dialog->getPassword();

    qDebug() << "password: " << password;

    qDebug() << "Starting gpg";

    QString program = "gpg";
    QStringList arguments;

    arguments <<"--batch" << "--passphrase-fd" <<"0" << "--decrypt" << fileName;
    qDebug() << "Command: " << program << arguments ;
    qDebug() << "Starting now";

    gpg->start(program, arguments);

    gpg->waitForStarted();

    qDebug() << "starting to write";


    QByteArray passwordArray;
    passwordArray.append(password);
    passwordArray.append("\n");
    gpg->write(passwordArray);

    gpg->waitForBytesWritten();
    gpg->closeWriteChannel();

    qDebug() << "Done";

}

   }


void pggui::slotErrorStringReceived()
{
    QString strLine = QString(gpg->readAllStandardError());

    gpgText->append(strLine);
}



void pggui::gpgDecode()
{
    QString *decodeString = new QString(*strLine);
    decodeString->remove(0,77);

    qDebug() << "decodeString: " << *decodeString;

    QByteArray x;
    x.append(*decodeString);

    qDebug() << "x: " << x;

    QByteArray text = QByteArray::fromBase64(x);

    qDebug() << "Text: " << text.data();

    QString y;
    y.append(text.data());
    gpgText->append(y);
}


pggui::~pggui()
{

}
