/*
 * This file is part of Personal IP Address.
 *
 * Copyright (C) 2009 Andrew Olmsted. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
*  
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/* personal-ip-address.c */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "personal-ip-address.h"
#include <hildon/hildon.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <conic.h>

#define HOME_DIR g_get_home_dir()

#define IP_COMMAND "/sbin/ifconfig | grep \"inet addr\" | awk -F: '{print $2}' | awk '{print $1}'"

#define _(String) dgettext("hildon-libs", String)

#define PERSONAL_IP_ADDRESS_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj,\
							                         PERSONAL_TYPE_IP_ADDRESS,\
							                         PersonalIpAddressPrivate))

struct _PersonalIpAddressPrivate
{
    GtkWidget *homeWidget;
    GtkWidget *contents;
	
	GtkWidget *ipLabel;
	GtkWidget *ipContent;
	
	gint refresh;
	
	ConIcConnection *connection;
	
	guint eventID;
};

HD_DEFINE_PLUGIN_MODULE (PersonalIpAddress, personal_ip_address, HD_TYPE_HOME_PLUGIN_ITEM);

//gboolean personal_ip_address_update_content (PersonalIpAddress *self);

/*void personal_ip_address_read_settings ( PersonalIpAddress *self )
{
	//g_warning("personal_ip_address_read_settings");	
    gchar *filename;
    gboolean fileExists;
    GKeyFile *keyFile;

    keyFile = g_key_file_new();
    filename = g_strconcat (HOME_DIR, "/.personal_ip_address", NULL);
    fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);

    if (fileExists) {
        GError *error=NULL;

        self->priv->refresh = g_key_file_get_integer (keyFile, "config", "refresh", &error);
        if (error) {
            self->priv->refresh = 5;
            g_error_free (error);
            error = NULL;
        }
		self->priv->binaryPrefix = g_key_file_get_boolean (keyFile, "config", "binaryPrefix", &error);
		if (error) {
			self->priv->binaryPrefix = FALSE;
			g_error_free (error);
			error = NULL;
		}
		self->priv->showResetDate = g_key_file_get_boolean (keyFile, "config", "showResetDate", &error);
		if (error) {
			self->priv->showResetDate = FALSE;
			g_error_free (error);
			error = NULL;
		}
    } else {
        self->priv->refresh = 5;
		self->priv->binaryPrefix = FALSE;
		self->priv->showResetDate = FALSE;
    }

    g_key_file_free (keyFile);
    g_free (filename);
}

void personal_ip_address_write_settings (PersonalIpAddress *self)
{
	//g_warning ("personal_ip_address_write_settings");
	GKeyFile *keyFile;
	gchar *fileData;
	FILE *iniFile;
	gsize size;
	GtkTreeIter iter;
	gboolean exists;
	gchar *filename;
	gint i=0;
	
	keyFile = g_key_file_new();
		
	g_key_file_set_integer (keyFile, "config", "refresh", self->priv->refresh);
	g_key_file_set_boolean (keyFile, "config", "binaryPrefix", self->priv->binaryPrefix);
	g_key_file_set_boolean (keyFile, "config", "showResetDate", self->priv->showResetDate);
	
	filename = g_strconcat (HOME_DIR, "/.personal_ip_address", NULL);
	fileData = g_key_file_to_data (keyFile, &size, NULL);
	iniFile = fopen (filename, "w");
	fputs (fileData, iniFile);
	fclose (iniFile);
	g_key_file_free (keyFile);
	g_free (fileData);
	g_free (filename);
}*/

void personal_ip_address_content_create (PersonalIpAddress *self)
{
	//g_warning ("personal_ip_address_content_create");
	self->priv->contents = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->contents), 0);
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	/*GtkWidget *image = gtk_image_new_from_icon_name ("personal-ip-address", GTK_ICON_SIZE_BUTTON);
    self->priv->titleLabel = gtk_label_new ("IP Address");
	hildon_helper_set_logical_font (self->priv->titleLabel, "EmpSystemFont");
	GtkWidget *titleBox = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (titleBox), 0);
	gtk_box_pack_start (GTK_BOX (titleBox), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (titleBox), self->priv->titleLabel, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 1);
	gtk_misc_set_padding (GTK_MISC (image), 2, 0);
	gtk_misc_set_alignment (GTK_MISC (self->priv->titleLabel), 0, 0.8);
	
	self->priv->ipLabel = gtk_label_new ("IP");
	gtk_size_group_add_widget (group, self->priv->ipLabel);
	self->priv->ipContent = gtk_label_new ("127.0.0.1");
	GtkWidget *ipBox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (ipBox), self->priv->ipLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (ipBox), self->priv->ipContent, TRUE, TRUE, 0);
	hildon_helper_set_logical_font (self->priv->ipLabel, "SmallSystemFont");
	hildon_helper_set_logical_font (self->priv->ipContent, "SmallSystemFont");
	hildon_helper_set_logical_color (self->priv->ipContent, GTK_RC_FG, GTK_STATE_NORMAL, "ActiveTextColor");
	gtk_misc_set_alignment (GTK_MISC (self->priv->ipLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (self->priv->ipLabel), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);
	gtk_misc_set_alignment (GTK_MISC (self->priv->ipContent), 1, 0.5);
	gtk_misc_set_padding (GTK_MISC (self->priv->ipContent), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);
	
	gtk_box_pack_start (GTK_BOX (self->priv->contents), titleBox, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (self->priv->contents), ipBox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), GTK_WIDGET (self->priv->contents), FALSE, FALSE, 0);*/
	
	GtkWidget *image = gtk_image_new_from_icon_name ("personal-ip-address", GTK_ICON_SIZE_BUTTON);
	GtkWidget *box = gtk_hbox_new (FALSE, 0);
	self->priv->ipContent = gtk_label_new ("255.255.255.255");
	gtk_box_pack_start (GTK_BOX (box), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), self->priv->ipContent, TRUE, TRUE, 0);
	//hildon_helper_set_logical_font (self->priv->ipContent, "SmallSystemFont");
	hildon_helper_set_logical_color (self->priv->ipContent, GTK_RC_FG, GTK_STATE_NORMAL, "ActiveTextColor");
	gtk_misc_set_alignment (GTK_MISC (self->priv->ipContent), 1, 0.8);
	gtk_misc_set_padding (GTK_MISC (self->priv->ipContent), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);

	gtk_box_pack_start (GTK_BOX (self->priv->contents), box, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->contents, FALSE, FALSE, 0);
	
    gtk_widget_show_all (self->priv->homeWidget);
}

gboolean personal_ip_address_update_content (ConIcConnection *connection, ConIcConnectionEvent *event, PersonalIpAddress *self)
{
	//g_warning ("personal_ip_address_update_content");
	FILE *fp;
	gchar line[130];
	gboolean found = FALSE;

	fp = popen (IP_COMMAND, "r");

	while (fgets (line, sizeof line, fp))
	{
		gchar *gline = g_strdup_printf ("%s", line);
		if (g_strcasecmp (g_strstrip (gline), "127.0.0.1") != 0) {
			gtk_label_set_text (GTK_LABEL (self->priv->ipContent), gline);
			found = TRUE;
		}
		g_free (gline);
	}
	pclose (fp);
	
	if (!found) {
		gtk_label_set_text (GTK_LABEL (self->priv->ipContent), "(no IP found)");
	}
	
	return TRUE;
}

/*void personal_ip_address_settings (HDHomePluginItem *hitem, PersonalIpAddress *self)
{
	//g_warning ("personal_ip_address_settings");
	GtkWidget *dialog = gtk_dialog_new_with_buttons ("Personal Dataplan Monitor Settings",
        NULL, 0,
        _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, NULL);
    GtkWidget *content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));
	
	GtkWidget *selector = hildon_touch_selector_new_text ();
	
	int i;
	for (i=0; i<=60; i++) {
		gchar *text = g_strdup_printf ("%d seconds(s)", i);
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), text);
		g_free (text);
	}
	self->priv->refresh;
	hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, self->priv->refresh);
	
	GtkWidget *refreshButton = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
	hildon_button_set_title (HILDON_BUTTON (refreshButton), "Update every");
	hildon_button_add_title_size_group (HILDON_BUTTON (refreshButton), group);
	hildon_button_set_alignment (HILDON_BUTTON (refreshButton), 0, 0.5, 0, 0);

	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (refreshButton),
                                     HILDON_TOUCH_SELECTOR (selector));
	gtk_container_add (GTK_CONTAINER (content_area), refreshButton);
	
	GtkWidget *refreshLabel = gtk_label_new ("'0' will refresh only when switching to the desktop");
	gtk_label_set_markup (GTK_LABEL (refreshLabel), "<small>'0' will refresh only when switching to the desktop</small>");
	gtk_container_add (GTK_CONTAINER (content_area), refreshLabel);
	
	GtkWidget *hbox = gtk_hbox_new (FALSE, 0);
	GtkWidget *binaryPrefix = hildon_gtk_radio_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, NULL);
	gtk_button_set_label (GTK_BUTTON (binaryPrefix), "Binary prefixes (KiB)");
	GtkWidget *siPrefix = hildon_gtk_radio_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, gtk_radio_button_get_group (GTK_RADIO_BUTTON (binaryPrefix)));
	gtk_button_set_label (GTK_BUTTON (siPrefix), "SI prefixes (kB)");
	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (binaryPrefix), FALSE);
	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (siPrefix), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (binaryPrefix), self->priv->binaryPrefix);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (siPrefix), !self->priv->binaryPrefix);
	gtk_container_add (GTK_CONTAINER (hbox), binaryPrefix);
	gtk_container_add (GTK_CONTAINER (hbox), siPrefix);
	gtk_container_add (GTK_CONTAINER (content_area), hbox);
	
	GtkWidget *showResetDate = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_button_set_label (GTK_BUTTON (showResetDate), "Display the last reset date");
	gtk_container_add (GTK_CONTAINER (content_area), showResetDate);
	hildon_check_button_set_active (HILDON_CHECK_BUTTON (showResetDate), self->priv->showResetDate);
	
	gtk_widget_show_all (dialog);
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		self->priv->refresh = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0);
		self->priv->binaryPrefix = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (binaryPrefix));
		self->priv->showResetDate = hildon_check_button_get_active (HILDON_CHECK_BUTTON (showResetDate));
		
		personal_ip_address_write_settings (self);
		personal_ip_address_update_content (self);
	}
	gtk_widget_destroy (dialog);
}*/

static void personal_ip_address_check_desktop (GObject *gobject, GParamSpec *pspec, PersonalIpAddress *self)
{
	//g_warning ("personal_ip_address_check_desktop");
	/*gchar *name = pspec->name;
	gboolean status;
	g_object_get (gobject, name, &status, NULL);
	if (status) {
		personal_ip_address_update_content (self);
		if (self->priv->eventID == 0) {
			self->priv->eventID = g_timeout_add (1*1000*60, (GSourceFunc)personal_ip_address_update_content, self);
		}
	} else if (self->priv->eventID != 0) {
		g_source_remove (self->priv->eventID);
		self->priv->eventID = 0;
	}*/
}

static void personal_ip_address_dispose (GObject *object)
{
	//g_warning ("personal_ip_address_dispose");
	PersonalIpAddress *self = PERSONAL_IP_ADDRESS (object);

	G_OBJECT_CLASS (personal_ip_address_parent_class)->dispose (object);
}

static void personal_ip_address_finalize (GObject *object)
{
	//g_warning ("personal_ip_address_finalize");
	PersonalIpAddress *self = PERSONAL_IP_ADDRESS (object);

	if (self->priv->eventID) {
		g_source_remove (self->priv->eventID);
	}
	g_object_unref (self->priv->connection);

	G_OBJECT_CLASS (personal_ip_address_parent_class)->finalize (object);
}

static void personal_ip_address_realize (GtkWidget *widget)
{
	//g_warning ("personal_ip_address_realize");
	GdkScreen *screen;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (personal_ip_address_parent_class)->realize (widget);
}

static gboolean personal_ip_address_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	//g_warning ("personal_ip_address_expose_event");
	PersonalIpAddress *self = PERSONAL_IP_ADDRESS (widget);
	cairo_t *cr;
	
	cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));

	GdkColor color;
	gtk_style_lookup_color (gtk_rc_get_style(widget), "ContentFrameColor", &color);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.5);
	
	gint width, height, x, y;
	gint radius = 5;
	gint iconOffset = 16;
	gint iconSize = 56;
	width = widget->allocation.width;
	height = iconSize - iconOffset;
	x = widget->allocation.x;
	y = widget->allocation.y + iconOffset;

	cairo_move_to(cr, x + radius, y);
	cairo_line_to(cr, x + width - radius, y);
	cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,
				y + radius);
	cairo_line_to(cr, x + width, y + height);
	cairo_curve_to(cr, x + width, y + height, x + width,
				y + height, x + width, y + height);
	cairo_line_to(cr, x, y + height);
	cairo_curve_to(cr, x, y + height, x, y + height, x,
				y + height);
	cairo_line_to(cr, x, y);
	cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

	cairo_fill_preserve(cr);
	
	gtk_style_lookup_color (gtk_rc_get_style(widget), "ActiveTextColor", &color);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.5);
	cairo_set_line_width (cr, 1);
	cairo_stroke (cr);
	
	width = widget->allocation.width;
	height = widget->allocation.height - iconSize;
	x = widget->allocation.x;
	y = iconSize;
	
	gtk_style_lookup_color (gtk_rc_get_style(widget), "DefaultBackgroundColor", &color);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.5);

	cairo_move_to(cr, x + radius, y);
	cairo_line_to(cr, x + width, y);
	cairo_line_to(cr, x + width, y + height - radius);
	cairo_curve_to(cr, x + width, y + height - radius, x + width,
				y + height, x + width - radius, y + height);
	cairo_line_to(cr, x + radius, y + height);
	cairo_curve_to(cr, x + radius, y + height, x, y + height, x,
				y + height - radius);
	cairo_line_to(cr, x, y);

	cairo_fill_preserve (cr);
	
	gtk_style_lookup_color (gtk_rc_get_style(widget), "ActiveTextColor", &color);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.5);
	cairo_set_line_width (cr, 1);
	cairo_stroke (cr);
	
	cairo_destroy(cr);

	return GTK_WIDGET_CLASS (personal_ip_address_parent_class)->expose_event (widget, event);
}

static void personal_ip_address_class_init (PersonalIpAddressClass *klass)
{
	//g_warning ("personal_ip_address_class_init");
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->dispose = personal_ip_address_dispose;
	object_class->finalize = personal_ip_address_finalize;
	
	widget_class->realize = personal_ip_address_realize;
	widget_class->expose_event = personal_ip_address_expose_event;

	g_type_class_add_private (klass, sizeof (PersonalIpAddressPrivate));
}

static void personal_ip_address_class_finalize (PersonalIpAddressClass *klass G_GNUC_UNUSED)
{
}

static void personal_ip_address_init (PersonalIpAddress *self)
{
	//g_warning ("personal_ip_address_init");
	self->priv = PERSONAL_IP_ADDRESS_GET_PRIVATE (self);
	self->priv->eventID = 0;
	
	self->priv->connection = con_ic_connection_new ();
	g_signal_connect (self->priv->connection, "connection-event", G_CALLBACK (personal_ip_address_update_content), self);
	g_object_set (self->priv->connection, "automatic-connection-events", TRUE);
	
	//hd_home_plugin_item_set_settings (&self->parent, TRUE);
	//g_signal_connect (&self->parent, "show-settings", G_CALLBACK (personal_ip_address_settings), self);

	gtk_window_set_default_size (GTK_WINDOW (self), 270, 56);
	
	self->priv->homeWidget = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);
	gtk_widget_show (self->priv->homeWidget);

	GdkGeometry hints;
	hints.min_width = 270;
	hints.min_height = 56;
	hints.max_width = 270;
	hints.max_height = 56;
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	
	//personal_ip_address_read_settings (self);
	
	personal_ip_address_content_create (self);
	
	g_signal_connect (self, "notify::is-on-current-desktop", G_CALLBACK (personal_ip_address_check_desktop), self);
}

PersonalIpAddress* personal_ip_address_new (void)
{
  return g_object_new (PERSONAL_TYPE_IP_ADDRESS, NULL);
}
