#ifndef STARTVIEW_H
#define STARTVIEW_H

#include <QWidget>
#include <historyview.h>
#include <cameraviewfinder.h>
#include <editview.h>

//! StartView class.
/*!
  This class creates the first view of the application
*/
class StartView : public QWidget
{
    Q_OBJECT
public:
    //! A Constructor.
    StartView();
private:
    //! Pointer to HistoryView class.
    HistoryView *history;
    //! Pointer to CameraLiveView class.
    CameraViewFinder *cameraViewFinder;
    //! Pointer to EditView class.
    EditView *edit;

private slots:
    //! Handle history button
    void historyButtonClicked();
    //! Handle track button
    void trackButtonClicked();
    //! Create new EditView
    void openEditView();

};

#endif // STARTVIEW_H
